/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.widget.content.loader;

import com.epam.ta.reportportal.commons.Predicates;
import com.epam.ta.reportportal.commons.querygen.Filter;
import com.epam.ta.reportportal.commons.validation.BusinessRule;
import com.epam.ta.reportportal.core.widget.content.MultilevelLoadContentStrategy;
import com.epam.ta.reportportal.core.widget.util.WidgetFilterUtil;
import com.epam.ta.reportportal.core.widget.util.WidgetOptionUtil;
import com.epam.ta.reportportal.dao.WidgetContentRepository;
import com.epam.ta.reportportal.entity.widget.WidgetOptions;
import com.epam.ta.reportportal.ws.model.ErrorType;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;

@Service
public class TopPatternContentLoader
implements MultilevelLoadContentStrategy {
    public static final Integer TOP_PATTERN_TEMPLATES_ATTRIBUTES_COUNT = 15;
    @Autowired
    private WidgetContentRepository widgetContentRepository;

    @Override
    public Map<String, ?> loadContent(List<String> contentFields, Map<Filter, Sort> filterSortMapping, WidgetOptions widgetOptions, String[] attributes, Map<String, String> params, int limit) {
        this.validateFilterSortMapping(filterSortMapping);
        this.validateWidgetOptions(widgetOptions);
        Filter filter = WidgetFilterUtil.GROUP_FILTERS.apply(filterSortMapping.keySet());
        Sort sort = WidgetFilterUtil.GROUP_SORTS.apply(filterSortMapping.values());
        List content = this.widgetContentRepository.patternTemplate(filter, sort, WidgetOptionUtil.getValueByKey("attributeKey", widgetOptions), params.get("patternTemplateName"), WidgetOptionUtil.getBooleanByKey("latest", widgetOptions), limit, TOP_PATTERN_TEMPLATES_ATTRIBUTES_COUNT.intValue());
        return content.isEmpty() ? Collections.emptyMap() : Collections.singletonMap("result", content);
    }

    private void validateFilterSortMapping(Map<Filter, Sort> filterSortMapping) {
        BusinessRule.expect((Object)MapUtils.isNotEmpty(filterSortMapping), (Predicate)Predicates.equalTo((Object)true)).verify(ErrorType.BAD_REQUEST_ERROR, new Object[]{"Filter-Sort mapping should not be empty"});
    }

    private void validateWidgetOptions(WidgetOptions widgetOptions) {
        BusinessRule.expect((Object)WidgetOptionUtil.getValueByKey("attributeKey", widgetOptions), StringUtils::isNotEmpty).verify(ErrorType.UNABLE_LOAD_WIDGET_CONTENT, new Object[]{"attributeKey should be specified for widget."});
    }
}

