/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.job;

import com.epam.ta.reportportal.commons.querygen.ConvertibleCondition;
import com.epam.ta.reportportal.commons.querygen.Filter;
import com.epam.ta.reportportal.commons.querygen.FilterCondition;
import com.epam.ta.reportportal.commons.querygen.Queryable;
import com.epam.ta.reportportal.dao.ProjectRepository;
import com.epam.ta.reportportal.entity.enums.KeepScreenshotsDelay;
import com.epam.ta.reportportal.entity.enums.ProjectAttributeEnum;
import com.epam.ta.reportportal.entity.project.Project;
import com.epam.ta.reportportal.exception.ReportPortalException;
import com.epam.ta.reportportal.job.LogCleanerService;
import com.epam.ta.reportportal.job.PageUtil;
import java.time.Duration;
import java.util.concurrent.atomic.AtomicLong;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CleanScreenshotsJob
implements Job {
    private static final Logger LOGGER = LoggerFactory.getLogger(CleanScreenshotsJob.class);
    private final ProjectRepository projectRepository;
    private final LogCleanerService logCleaner;

    @Autowired
    public CleanScreenshotsJob(ProjectRepository projectRepository, LogCleanerService logCleaner) {
        this.projectRepository = projectRepository;
        this.logCleaner = logCleaner;
    }

    public void execute(JobExecutionContext context) {
        LOGGER.info("Cleaning outdated screenshots has been started");
        PageUtil.iterateOverPages(pageable -> this.projectRepository.findAllIdsAndProjectAttributes((Queryable)this.buildProjectAttributesFilter(ProjectAttributeEnum.KEEP_SCREENSHOTS), pageable), projects -> projects.forEach(project -> {
            AtomicLong attachmentsCount = new AtomicLong(0L);
            AtomicLong thumbnailsCount = new AtomicLong(0L);
            try {
                LOGGER.debug("Cleaning outdated screenshots for project {} has been started", (Object)project.getId());
                this.proceedScreenShotsCleaning((Project)project, attachmentsCount, thumbnailsCount);
            }
            catch (Exception e) {
                LOGGER.error("Cleaning outdated screenshots for project {} has been failed", (Object)project.getId(), (Object)e);
            }
            if (attachmentsCount.get() > 0L || thumbnailsCount.get() > 0L) {
                LOGGER.info("Cleaning outdated screenshots for project {} has been finished. {} attachments and {} thumbnails have been deleted", new Object[]{project.getId(), attachmentsCount.get(), thumbnailsCount.get()});
            }
        }));
    }

    private Filter buildProjectAttributesFilter(ProjectAttributeEnum projectAttributeEnum) {
        return Filter.builder().withTarget(Project.class).withCondition((ConvertibleCondition)FilterCondition.builder().eq("attributeName", projectAttributeEnum.getAttribute()).build()).build();
    }

    private void proceedScreenShotsCleaning(Project project, AtomicLong attachmentsCount, AtomicLong thumbnailsCount) {
        project.getProjectAttributes().stream().filter(pa -> pa.getAttribute().getName().equalsIgnoreCase(ProjectAttributeEnum.KEEP_SCREENSHOTS.getAttribute())).findFirst().ifPresent(pa -> {
            Duration period = Duration.ofDays(((KeepScreenshotsDelay)KeepScreenshotsDelay.findByName((String)pa.getValue()).orElseThrow(() -> new ReportPortalException("Incorrect keep screenshots delay period: " + pa.getValue()))).getDays());
            if (!period.isZero()) {
                this.logCleaner.removeProjectAttachments(project, period, attachmentsCount, thumbnailsCount);
            }
        });
    }
}

