/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.plugin;

import com.epam.reportportal.extension.ReportPortalExtensionPoint;
import com.epam.reportportal.extension.common.ExtensionPoint;
import com.epam.ta.reportportal.commons.validation.BusinessRule;
import com.epam.ta.reportportal.commons.validation.Suppliers;
import com.epam.ta.reportportal.core.integration.plugin.PluginLoader;
import com.epam.ta.reportportal.core.integration.util.property.IntegrationDetailsProperties;
import com.epam.ta.reportportal.core.plugin.Pf4jPluginBox;
import com.epam.ta.reportportal.core.plugin.Plugin;
import com.epam.ta.reportportal.core.plugin.PluginInfo;
import com.epam.ta.reportportal.dao.IntegrationTypeRepository;
import com.epam.ta.reportportal.entity.enums.IntegrationGroupEnum;
import com.epam.ta.reportportal.entity.integration.IntegrationType;
import com.epam.ta.reportportal.entity.integration.IntegrationTypeDetails;
import com.epam.ta.reportportal.entity.plugin.PluginFileExtension;
import com.epam.ta.reportportal.exception.ReportPortalException;
import com.epam.ta.reportportal.ws.model.ErrorType;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.util.concurrent.AbstractIdleService;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.pf4j.PluginException;
import org.pf4j.PluginManager;
import org.pf4j.PluginState;
import org.pf4j.PluginWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;
import org.springframework.beans.factory.support.AbstractAutowireCapableBeanFactory;

public class Pf4jPluginManager
extends AbstractIdleService
implements Pf4jPluginBox {
    public static final Logger LOGGER = LoggerFactory.getLogger(Pf4jPluginManager.class);
    private static final long MAXIMUM_UPLOADED_PLUGINS = 50L;
    private static final long PLUGIN_LIVE_TIME = 2L;
    private final String pluginsDir;
    private final String pluginsTempDir;
    private final Cache<String, Path> uploadingPlugins;
    private final PluginLoader pluginLoader;
    private final IntegrationTypeRepository integrationTypeRepository;
    private final PluginManager pluginManager;
    private final AutowireCapableBeanFactory autowireCapableBeanFactory;

    public Pf4jPluginManager(String pluginsDir, String pluginsTempPath, PluginLoader pluginLoader, IntegrationTypeRepository integrationTypeRepository, PluginManager pluginManager, AutowireCapableBeanFactory autowireCapableBeanFactory) throws IOException {
        this.pluginsDir = pluginsDir;
        this.autowireCapableBeanFactory = autowireCapableBeanFactory;
        Files.createDirectories(Paths.get(this.pluginsDir, new String[0]), new FileAttribute[0]);
        this.pluginsTempDir = pluginsTempPath;
        Files.createDirectories(Paths.get(this.pluginsTempDir, new String[0]), new FileAttribute[0]);
        this.pluginLoader = pluginLoader;
        this.integrationTypeRepository = integrationTypeRepository;
        this.uploadingPlugins = CacheBuilder.newBuilder().maximumSize(50L).expireAfterWrite(2L, TimeUnit.MINUTES).build();
        this.pluginManager = pluginManager;
    }

    @Override
    public List<Plugin> getPlugins() {
        return this.pluginManager.getPlugins().stream().flatMap(plugin -> this.pluginManager.getExtensionClasses(plugin.getPluginId()).stream().map(ExtensionPoint::findByExtension).filter(Optional::isPresent).map(it -> new Plugin(plugin.getPluginId(), (ExtensionPoint)it.get()))).collect(Collectors.toList());
    }

    @Override
    public Optional<Plugin> getPlugin(String type) {
        return this.getPlugins().stream().filter(p -> p.getType().name().equalsIgnoreCase(type)).findAny();
    }

    @Override
    public <T> Optional<T> getInstance(Class<T> extension) {
        return this.pluginManager.getExtensions(extension).stream().findFirst();
    }

    @Override
    public PluginState startUpPlugin(String pluginId) {
        PluginWrapper pluginWrapper = Optional.ofNullable(this.pluginManager.getPlugin(pluginId)).orElseThrow(() -> new ReportPortalException(ErrorType.UNABLE_INTERACT_WITH_INTEGRATION, new Object[]{"Plugin not found: " + pluginId}));
        return this.pluginManager.startPlugin(pluginWrapper.getPluginId());
    }

    @Override
    public boolean loadPlugin(String pluginId, IntegrationTypeDetails integrationTypeDetails) {
        return Optional.ofNullable(integrationTypeDetails.getDetails()).map(details -> {
            String fileName = IntegrationDetailsProperties.FILE_NAME.getValue((Map<String, Object>)details).map(String::valueOf).orElseThrow(() -> new ReportPortalException(ErrorType.PLUGIN_UPLOAD_ERROR, new Object[]{Suppliers.formattedSupplier((String)"'File name' property of the plugin - '{}' is not specified", (Object[])new Object[]{pluginId}).get()}));
            Path pluginPath = Paths.get(this.pluginsDir, fileName);
            if (Files.notExists(pluginPath, new LinkOption[0])) {
                String fileId = IntegrationDetailsProperties.FILE_ID.getValue((Map<String, Object>)details).map(String::valueOf).orElseThrow(() -> new ReportPortalException(ErrorType.PLUGIN_UPLOAD_ERROR, new Object[]{Suppliers.formattedSupplier((String)"'File id' property of the plugin - '{}' is not specified", (Object[])new Object[]{pluginId}).get()}));
                try {
                    this.pluginLoader.copyFromDataStore(fileId, pluginPath);
                }
                catch (IOException e) {
                    throw new ReportPortalException(ErrorType.PLUGIN_UPLOAD_ERROR, new Object[]{Suppliers.formattedSupplier((String)"Unable to load plugin - '{}' from the data store", (Object[])new Object[]{pluginId}).get()});
                }
            }
            return Optional.ofNullable(this.pluginManager.loadPlugin(pluginPath)).map(id -> {
                if (PluginState.STARTED == this.pluginManager.startPlugin(pluginId)) {
                    Optional<ExtensionPoint> extensionPoint = this.getInstance(pluginId, ExtensionPoint.class);
                    extensionPoint.ifPresent(extension -> LOGGER.info((String)Suppliers.formattedSupplier((String)"Plugin - '{}' initialized.", (Object[])new Object[]{pluginId}).get()));
                    return true;
                }
                return false;
            }).orElse(Boolean.FALSE);
        }).orElse(Boolean.FALSE);
    }

    @Override
    public boolean unloadPlugin(IntegrationType integrationType) {
        this.destroyDependency(integrationType.getName());
        return this.pluginManager.unloadPlugin(integrationType.getName());
    }

    private void destroyDependency(String name) {
        AbstractAutowireCapableBeanFactory beanFactory = (AbstractAutowireCapableBeanFactory)this.autowireCapableBeanFactory;
        if (beanFactory.containsSingleton(name)) {
            beanFactory.destroySingleton(name);
        }
    }

    @Override
    public boolean deletePlugin(String pluginId) {
        return this.integrationTypeRepository.findByName(pluginId).map(integrationType -> {
            Optional<Map> pluginData = Optional.ofNullable(integrationType.getDetails()).map(IntegrationTypeDetails::getDetails);
            pluginData.flatMap(details -> IntegrationDetailsProperties.FILE_ID.getValue((Map<String, Object>)details).map(String::valueOf)).ifPresent(this.pluginLoader::deleteFromDataStore);
            return Optional.ofNullable(this.pluginManager.getPlugin(pluginId)).map(pluginWrapper -> {
                this.destroyDependency(pluginWrapper.getPluginId());
                if (integrationType.isEnabled()) {
                    return this.pluginManager.deletePlugin(pluginId);
                }
                return pluginData.flatMap(details -> IntegrationDetailsProperties.FILE_NAME.getValue((Map<String, Object>)details).map(String::valueOf).map(fileName -> Paths.get(this.pluginsDir, fileName))).map(path -> {
                    try {
                        return Files.deleteIfExists(path);
                    }
                    catch (IOException e) {
                        throw new ReportPortalException(ErrorType.PLUGIN_REMOVE_ERROR, new Object[]{"Error during plugin file removing from the filesystem: " + e.getMessage()});
                    }
                }).orElse(Boolean.TRUE);
            }).orElse(Boolean.TRUE);
        }).orElse(Boolean.TRUE);
    }

    @Override
    public Optional<PluginWrapper> getPluginById(String id) {
        return Optional.ofNullable(this.pluginManager.getPlugin(id));
    }

    @Override
    public boolean isInUploadingState(String fileName) {
        return this.uploadingPlugins.asMap().containsKey(fileName);
    }

    @Override
    public <T> Optional<T> getInstance(String name, Class<T> extension) {
        return this.pluginManager.getExtensions(extension, name).stream().findFirst();
    }

    protected void startUp() {
        this.integrationTypeRepository.findAll().stream().filter(IntegrationType::isEnabled).forEach(integrationType -> Optional.ofNullable(integrationType.getDetails()).ifPresent(integrationTypeDetails -> this.loadPlugin(integrationType.getName(), (IntegrationTypeDetails)integrationTypeDetails)));
    }

    protected void shutDown() {
        this.pluginManager.stopPlugins();
        this.pluginManager.getPlugins().forEach(p -> this.pluginManager.unloadPlugin(p.getPluginId()));
    }

    @Override
    public IntegrationType uploadPlugin(String newPluginFileName, InputStream fileStream) {
        PluginInfo newPluginInfo = this.resolvePluginInfo(newPluginFileName, fileStream);
        IntegrationType integrationType = this.pluginLoader.retrieveIntegrationType(newPluginInfo);
        Optional<PluginWrapper> previousPlugin = this.getPluginById(newPluginInfo.getId());
        this.validateNewPluginFile(previousPlugin, newPluginFileName);
        previousPlugin.ifPresent(this::unloadPlugin);
        String newPluginId = this.pluginManager.loadPlugin(Paths.get(this.pluginsTempDir, newPluginFileName));
        if (Optional.ofNullable(newPluginId).isPresent()) {
            IntegrationType newIntegrationType = this.startUpPlugin(newPluginId, previousPlugin, newPluginFileName, integrationType);
            this.deleteTempPlugin(newPluginFileName);
            return newIntegrationType;
        }
        previousPlugin.ifPresent(this::loadAndStartUpPlugin);
        this.deleteTempPlugin(newPluginFileName);
        throw new ReportPortalException(ErrorType.PLUGIN_UPLOAD_ERROR, new Object[]{Suppliers.formattedSupplier((String)"Failed to load new plugin from file = {}", (Object[])new Object[]{newPluginFileName}).get()});
    }

    private PluginInfo resolvePluginInfo(String fileName, InputStream fileStream) {
        Path pluginsTempPath = Paths.get(this.pluginsTempDir, new String[0]);
        this.createTempPluginsFolderIfNotExists(pluginsTempPath);
        this.validateFileExtension(fileName);
        this.uploadTempPlugin(fileName, fileStream);
        try {
            PluginInfo newPluginInfo = this.pluginLoader.extractPluginInfo(Paths.get(this.pluginsTempDir, fileName));
            this.validatePluginMetaInfo(newPluginInfo, fileName);
            return newPluginInfo;
        }
        catch (PluginException e) {
            this.removeUploadingPlugin(fileName);
            throw new ReportPortalException(ErrorType.PLUGIN_UPLOAD_ERROR, new Object[]{e.getMessage()});
        }
    }

    private void createTempPluginsFolderIfNotExists(Path path) {
        if (!Files.isDirectory(path, new LinkOption[0])) {
            try {
                Files.createDirectories(path, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new ReportPortalException(ErrorType.PLUGIN_UPLOAD_ERROR, new Object[]{Suppliers.formattedSupplier((String)"Unable to create directory = {}", (Object[])new Object[]{path}).get()});
            }
        }
    }

    private void validateFileExtension(String fileName) {
        String resolvedExtension = FilenameUtils.getExtension((String)fileName);
        Optional byExtension = PluginFileExtension.findByExtension((String)("." + resolvedExtension));
        BusinessRule.expect((Object)byExtension, Optional::isPresent).verify(ErrorType.PLUGIN_UPLOAD_ERROR, new Object[]{Suppliers.formattedSupplier((String)"Unsupported plugin file extension = {}", (Object[])new Object[]{resolvedExtension}).get()});
    }

    private void validatePluginMetaInfo(PluginInfo newPluginInfo, String fileName) {
        if (!Optional.ofNullable(newPluginInfo.getVersion()).isPresent()) {
            this.removeUploadingPlugin(fileName);
            throw new ReportPortalException(ErrorType.PLUGIN_UPLOAD_ERROR, new Object[]{"Plugin version should be specified."});
        }
    }

    private void validateNewPluginFile(Optional<PluginWrapper> previousPlugin, String newPluginFileName) {
        if (!(!new File(this.pluginsDir, newPluginFileName).exists() || previousPlugin.isPresent() && Paths.get(this.pluginsDir, newPluginFileName).equals(previousPlugin.get().getPluginPath()))) {
            throw new ReportPortalException(ErrorType.PLUGIN_UPLOAD_ERROR, new Object[]{Suppliers.formattedSupplier((String)"Unable to rewrite plugin file = '{}' with different plugin type", (Object[])new Object[]{newPluginFileName}).get()});
        }
    }

    private void uploadTempPlugin(String fileName, InputStream fileStream) {
        try {
            Path pluginPath = Paths.get(this.pluginsTempDir, fileName);
            this.addUploadingPlugin(fileName, pluginPath);
            this.pluginLoader.savePlugin(pluginPath, fileStream);
        }
        catch (IOException e) {
            this.removeUploadingPlugin(fileName);
            throw new ReportPortalException(ErrorType.PLUGIN_UPLOAD_ERROR, new Object[]{Suppliers.formattedSupplier((String)"Unable to copy the new plugin file with name = {} to the temp directory", (Object[])new Object[]{fileName}).get()});
        }
    }

    private void addUploadingPlugin(String fileName, Path path) {
        this.uploadingPlugins.put((Object)fileName, (Object)path);
    }

    private void removeUploadingPlugin(String fileName) {
        this.uploadingPlugins.invalidate((Object)fileName);
    }

    private void unloadPlugin(PluginWrapper pluginWrapper) {
        if (!this.pluginManager.unloadPlugin(pluginWrapper.getPluginId())) {
            throw new ReportPortalException(ErrorType.PLUGIN_REMOVE_ERROR, new Object[]{Suppliers.formattedSupplier((String)"Failed to stop old plugin with id = {}", (Object[])new Object[]{pluginWrapper.getPluginId()}).get()});
        }
    }

    private IntegrationType startUpPlugin(String newPluginId, Optional<PluginWrapper> previousPlugin, String newPluginFileName, IntegrationType integrationType) {
        this.startUpPlugin(newPluginId);
        this.validateNewPluginExtensionClasses(newPluginId, previousPlugin, newPluginFileName);
        this.pluginManager.unloadPlugin(newPluginId);
        String fileId = this.uploadPlugin(newPluginFileName, previousPlugin, newPluginId);
        IntegrationDetailsProperties.FILE_ID.setValue(integrationType.getDetails(), fileId);
        this.copyPluginToRootDirectory(newPluginFileName, previousPlugin, newPluginId);
        previousPlugin.ifPresent(p -> this.deletePreviousPlugin((PluginWrapper)p, newPluginFileName));
        return Optional.ofNullable(this.pluginManager.loadPlugin(Paths.get(this.pluginsDir, newPluginFileName))).map(newLoadedPluginId -> {
            this.startUpPlugin((String)newLoadedPluginId);
            integrationType.setName(newLoadedPluginId);
            integrationType.setIntegrationGroup(IntegrationGroupEnum.OTHER);
            this.integrationTypeRepository.save((Object)integrationType);
            Optional<ReportPortalExtensionPoint> instance = this.getInstance(integrationType.getName(), ReportPortalExtensionPoint.class);
            if (instance.isPresent()) {
                integrationType.getDetails().getDetails().putAll(instance.get().getPluginParams());
                integrationType.setIntegrationGroup(IntegrationGroupEnum.valueOf((String)instance.get().getIntegrationGroup().name()));
            }
            IntegrationDetailsProperties.FILE_NAME.setValue(integrationType.getDetails(), newPluginFileName);
            integrationType.setEnabled(true);
            return (IntegrationType)this.integrationTypeRepository.save((Object)integrationType);
        }).orElseThrow(() -> new ReportPortalException(ErrorType.PLUGIN_UPLOAD_ERROR, new Object[]{Suppliers.formattedSupplier((String)"Error during loading the plugin file = '{}'", (Object[])new Object[]{newPluginFileName}).get()}));
    }

    private void validateNewPluginExtensionClasses(String newPluginId, Optional<PluginWrapper> previousPlugin, String newPluginFileName) {
        PluginWrapper newPlugin = this.getPluginById(newPluginId).orElseThrow(() -> new ReportPortalException(ErrorType.PLUGIN_UPLOAD_ERROR, new Object[]{Suppliers.formattedSupplier((String)"Plugin with id = {} has not been found.", (Object[])new Object[]{newPluginId}).get()}));
        if (!this.pluginLoader.validatePluginExtensionClasses(newPlugin)) {
            this.pluginManager.unloadPlugin(newPluginId);
            previousPlugin.ifPresent(this::loadAndStartUpPlugin);
            this.deleteTempPlugin(newPluginFileName);
            throw new ReportPortalException(ErrorType.PLUGIN_UPLOAD_ERROR, new Object[]{Suppliers.formattedSupplier((String)"New plugin with id = {} doesn't have mandatory extension classes.", (Object[])new Object[]{newPluginId}).get()});
        }
    }

    private void deleteTempPlugin(String newPluginFileName) {
        try {
            this.pluginLoader.deleteTempPlugin(this.pluginsTempDir, newPluginFileName);
        }
        catch (IOException e) {
            LOGGER.error("Error during temp plugin file removing.", (Object)e.getMessage());
        }
        finally {
            this.removeUploadingPlugin(newPluginFileName);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String uploadPlugin(String fileName, Optional<PluginWrapper> previousPlugin, String newPluginId) {
        try (FileInputStream fileStream = FileUtils.openInputStream((File)FileUtils.getFile((String[])new String[]{this.pluginsTempDir, fileName}));){
            String string = this.pluginLoader.saveToDataStore(fileName, fileStream);
            return string;
        }
        catch (Exception e) {
            previousPlugin.ifPresent(this::loadAndStartUpPlugin);
            throw new ReportPortalException(ErrorType.PLUGIN_UPLOAD_ERROR, new Object[]{Suppliers.formattedSupplier((String)"Unable to upload the new plugin file with id = {} to the data store", (Object[])new Object[]{newPluginId}).get()});
        }
    }

    private void copyPluginToRootDirectory(String newPluginFileName, Optional<PluginWrapper> previousPlugin, String newPluginId) {
        File tempPluginFile = FileUtils.getFile((String[])new String[]{this.pluginsTempDir, newPluginFileName});
        try {
            FileUtils.copyFile((File)tempPluginFile, (File)new File(this.pluginsDir, newPluginFileName));
        }
        catch (IOException e) {
            previousPlugin.ifPresent(this::loadAndStartUpPlugin);
            throw new ReportPortalException(ErrorType.PLUGIN_UPLOAD_ERROR, new Object[]{Suppliers.formattedSupplier((String)"Unable to copy the new plugin file with id = {} to the root directory", (Object[])new Object[]{newPluginId}).get()});
        }
        finally {
            this.removeUploadingPlugin(newPluginFileName);
        }
    }

    private void deletePreviousPlugin(PluginWrapper previousPlugin, String newPluginFileName) {
        try {
            this.pluginLoader.deletePreviousPlugin(previousPlugin, newPluginFileName);
        }
        catch (IOException e) {
            this.loadAndStartUpPlugin(previousPlugin);
            throw new ReportPortalException(ErrorType.PLUGIN_REMOVE_ERROR, new Object[]{Suppliers.formattedSupplier((String)"Unable to delete the old plugin file with id = {}", (Object[])new Object[]{previousPlugin.getPluginId()}).get()});
        }
    }

    private PluginState loadAndStartUpPlugin(PluginWrapper plugin) {
        if (plugin.getPluginState() == PluginState.STARTED) {
            return plugin.getPluginState();
        }
        return this.startUpPlugin(Optional.ofNullable(this.pluginManager.loadPlugin(plugin.getPluginPath())).orElseThrow(() -> new ReportPortalException(ErrorType.PLUGIN_UPLOAD_ERROR, new Object[]{Suppliers.formattedSupplier((String)"Unable to reload plugin with id = '{}", (Object[])new Object[]{plugin.getPluginId()}).get()})));
    }
}

