/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.util;

import com.epam.ta.reportportal.entity.ItemAttribute;
import com.epam.ta.reportportal.exception.ReportPortalException;
import com.epam.ta.reportportal.util.Predicates;
import com.epam.ta.reportportal.ws.model.BulkInfoUpdateRQ;
import com.epam.ta.reportportal.ws.model.ErrorType;
import com.epam.ta.reportportal.ws.model.attribute.ItemAttributeResource;
import com.epam.ta.reportportal.ws.model.attribute.UpdateItemAttributeRQ;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public class ItemInfoUtils {
    private ItemInfoUtils() {
    }

    public static Optional<String> updateDescription(BulkInfoUpdateRQ.Description descriptionRq, String existDescription) {
        if (!Objects.isNull(descriptionRq) && !Objects.isNull(descriptionRq.getComment())) {
            switch (descriptionRq.getAction()) {
                case UPDATE: {
                    return Optional.of(existDescription + " " + descriptionRq.getComment());
                }
                case CREATE: {
                    return Optional.of(descriptionRq.getComment());
                }
            }
            return Optional.empty();
        }
        return Optional.empty();
    }

    public static ItemAttribute findAttributeByResource(Set<ItemAttribute> attributes, ItemAttributeResource resource) {
        return attributes.stream().filter(attr -> Predicates.ITEM_ATTRIBUTE_EQUIVALENCE.test((ItemAttribute)attr, resource)).findAny().orElseThrow(() -> new ReportPortalException(ErrorType.INCORRECT_REQUEST, new Object[]{"Cannot delete not common attribute"}));
    }

    public static void updateAttribute(Set<ItemAttribute> attributes, UpdateItemAttributeRQ updateItemAttributeRQ) {
        attributes.stream().filter(attr -> Predicates.ITEM_ATTRIBUTE_EQUIVALENCE.test((ItemAttribute)attr, updateItemAttributeRQ.getFrom())).findAny().map(attr -> {
            attributes.remove(attr);
            attr.setKey(updateItemAttributeRQ.getTo().getKey());
            attr.setValue(updateItemAttributeRQ.getTo().getValue());
            attributes.add((ItemAttribute)attr);
            return attr;
        }).orElseThrow(() -> new ReportPortalException(ErrorType.INCORRECT_REQUEST, new Object[]{"Cannot update not common attribute"}));
    }

    public static boolean containsAttribute(Set<ItemAttribute> attributes, ItemAttributeResource resource) {
        return attributes.stream().noneMatch(attr -> Predicates.ITEM_ATTRIBUTE_EQUIVALENCE.test((ItemAttribute)attr, resource));
    }
}

