/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.auth.acl;

import java.util.List;
import java.util.Optional;
import javax.sql.DataSource;
import org.springframework.security.acls.domain.ObjectIdentityImpl;
import org.springframework.security.acls.domain.PrincipalSid;
import org.springframework.security.acls.jdbc.JdbcMutableAclService;
import org.springframework.security.acls.jdbc.LookupStrategy;
import org.springframework.security.acls.model.AccessControlEntry;
import org.springframework.security.acls.model.AclCache;
import org.springframework.security.acls.model.MutableAcl;
import org.springframework.security.acls.model.ObjectIdentity;
import org.springframework.security.acls.model.Permission;
import org.springframework.security.acls.model.Sid;

public class ReportPortalAclService
extends JdbcMutableAclService {
    private static final String IDENTITY_QUERY = "select currval(pg_get_serial_sequence('acl_class', 'id'))";
    private static final String SID_IDENTITY_QUERY = "select currval(pg_get_serial_sequence('acl_sid', 'id'))";
    private static final String OBJECT_IDENTITY_PRIMARY_KEY_QUERY = "select acl_object_identity.id\nfrom acl_object_identity,\n     acl_class\nwhere acl_object_identity.object_id_class = acl_class.id\n  and acl_class.class= ? \n  and acl_object_identity.object_id_identity = ? ::varchar";
    private static final String FIND_CHILDREN_QUERY = "select obj.object_id_identity as obj_id, class.class as class from acl_object_identity obj, acl_object_identity parent, acl_class class where obj.parent_object = parent.id and obj.object_id_class = class.id and parent.object_id_identity = ?::varchar and parent.object_id_class = (select id FROM acl_class where acl_class.class = ?)";

    public ReportPortalAclService(DataSource dataSource, LookupStrategy lookupStrategy, AclCache aclCache) {
        super(dataSource, lookupStrategy, aclCache);
        this.setClassIdentityQuery(IDENTITY_QUERY);
        this.setSidIdentityQuery(SID_IDENTITY_QUERY);
        this.setObjectIdentityPrimaryKeyQuery(OBJECT_IDENTITY_PRIMARY_KEY_QUERY);
        this.setFindChildrenQuery(FIND_CHILDREN_QUERY);
        this.setAclClassIdSupported(true);
    }

    Optional<MutableAcl> createAcl(Object object) {
        Optional<MutableAcl> acl = this.getAcl(object);
        if (acl.isPresent()) {
            return acl;
        }
        return Optional.of(this.createAcl((ObjectIdentity)new ObjectIdentityImpl(object)));
    }

    void deleteAcl(Object object) {
        Optional<MutableAcl> acl = this.getAcl(object);
        if (acl.isPresent()) {
            this.deleteAcl((ObjectIdentity)new ObjectIdentityImpl(object), true);
        }
    }

    Optional<MutableAcl> addPermissions(Object object, String userName, Permission permission) {
        Optional<MutableAcl> acl = this.getAcl(object);
        if (!acl.isPresent() || this.isAceExistForUser(acl.get(), userName)) {
            return acl;
        }
        PrincipalSid sid = new PrincipalSid(userName);
        acl.get().insertAce(0, permission, (Sid)sid, true);
        this.updateAcl(acl.get());
        return acl;
    }

    Optional<MutableAcl> removePermissions(Object object, String userName) {
        Optional<MutableAcl> acl = this.getAcl(object);
        if (acl.isPresent() && this.isAceExistForUser(acl.get(), userName)) {
            PrincipalSid sid = new PrincipalSid(userName);
            if (!acl.get().getOwner().equals((Object)sid)) {
                for (int i = 0; i < acl.get().getEntries().size(); ++i) {
                    AccessControlEntry entry = (AccessControlEntry)acl.get().getEntries().get(i);
                    if (!sid.equals((Object)entry.getSid())) continue;
                    acl.get().deleteAce(i);
                    break;
                }
                this.updateAcl(acl.get());
                return acl;
            }
        }
        return acl;
    }

    private boolean isAceExistForUser(MutableAcl acl, String userName) {
        PrincipalSid sid = new PrincipalSid(userName);
        List entries = acl.getEntries();
        for (AccessControlEntry ace : entries) {
            if (ace == null || !sid.equals((Object)ace.getSid())) continue;
            return true;
        }
        return false;
    }

    Optional<MutableAcl> getAcl(Object object) {
        ObjectIdentityImpl objectIdentity = new ObjectIdentityImpl(object);
        if (this.retrieveObjectIdentityPrimaryKey((ObjectIdentity)objectIdentity) != null) {
            return Optional.of((MutableAcl)this.readAclById((ObjectIdentity)objectIdentity));
        }
        return Optional.empty();
    }
}

