/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.auth.basic;

import com.epam.ta.reportportal.auth.util.AuthUtils;
import com.epam.ta.reportportal.commons.EntityUtils;
import com.epam.ta.reportportal.commons.ReportPortalUser;
import com.epam.ta.reportportal.dao.UserRepository;
import java.util.Collection;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.userdetails.User;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DatabaseUserDetailsService
implements UserDetailsService {
    private UserRepository userRepository;

    @Autowired
    public void setUserRepository(UserRepository userRepository) {
        this.userRepository = userRepository;
    }

    @Transactional(readOnly=true)
    public UserDetails loadUserByUsername(String username) throws UsernameNotFoundException {
        ReportPortalUser user = (ReportPortalUser)this.userRepository.findUserDetails(EntityUtils.normalizeId((String)username)).orElseThrow(() -> new UsernameNotFoundException("User not found"));
        UserDetails userDetails = User.builder().username(user.getUsername()).password(user.getPassword() == null ? "" : user.getPassword()).authorities((Collection)AuthUtils.AS_AUTHORITIES.apply(user.getUserRole())).build();
        return ReportPortalUser.userBuilder().withUserDetails(userDetails).withProjectDetails(user.getProjectDetails()).withUserId(user.getUserId()).withUserRole(user.getUserRole()).withEmail(user.getEmail()).build();
    }
}

