/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.auth.event;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.servlet.http.HttpServletRequest;
import org.springframework.context.ApplicationListener;
import org.springframework.security.authentication.event.AuthenticationFailureBadCredentialsEvent;
import org.springframework.security.web.util.matcher.RequestHeaderRequestMatcher;
import org.springframework.stereotype.Component;

@Component
public class UiAuthenticationFailureEventHandler
implements ApplicationListener<AuthenticationFailureBadCredentialsEvent> {
    private static final long MAXIMUM_SIZE = 5000L;
    private static final long EXPIRATION_SECONDS = 30L;
    private static final int MAX_ATTEMPTS = 3;
    private static final RequestHeaderRequestMatcher AJAX_REQUEST_MATCHER = new RequestHeaderRequestMatcher("X-Requested-With", "XMLHttpRequest");
    @Inject
    private Provider<HttpServletRequest> request;
    private LoadingCache<String, AtomicInteger> failures = CacheBuilder.newBuilder().maximumSize(5000L).expireAfterWrite(30L, TimeUnit.SECONDS).build((CacheLoader)new CacheLoader<String, AtomicInteger>(){

        public AtomicInteger load(String key) {
            return new AtomicInteger(0);
        }
    });

    public boolean isBlocked(HttpServletRequest request) {
        AtomicInteger attempts = (AtomicInteger)this.failures.getIfPresent((Object)this.getClientIP(request));
        return null != attempts && attempts.get() > 3;
    }

    private void onAjaxFailure(HttpServletRequest request) {
        String clientIP = this.getClientIP(request);
        ((AtomicInteger)this.failures.getUnchecked((Object)clientIP)).incrementAndGet();
    }

    private String getClientIP(HttpServletRequest request) {
        String xfHeader = request.getHeader("X-Forwarded-For");
        if (xfHeader == null) {
            return request.getRemoteAddr();
        }
        return xfHeader.split(",")[0];
    }

    public void onApplicationEvent(AuthenticationFailureBadCredentialsEvent event) {
        this.onAjaxFailure((HttpServletRequest)this.request.get());
    }
}

