/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.dashboard.impl;

import com.epam.ta.reportportal.auth.acl.ShareableObjectsHandler;
import com.epam.ta.reportportal.commons.ReportPortalUser;
import com.epam.ta.reportportal.core.dashboard.DeleteDashboardHandler;
import com.epam.ta.reportportal.core.events.MessageBus;
import com.epam.ta.reportportal.core.events.activity.DashboardDeletedEvent;
import com.epam.ta.reportportal.core.shareable.GetShareableEntityHandler;
import com.epam.ta.reportportal.dao.DashboardRepository;
import com.epam.ta.reportportal.dao.DashboardWidgetRepository;
import com.epam.ta.reportportal.dao.WidgetRepository;
import com.epam.ta.reportportal.entity.dashboard.Dashboard;
import com.epam.ta.reportportal.entity.dashboard.DashboardWidget;
import com.epam.ta.reportportal.ws.converter.converters.DashboardConverter;
import com.epam.ta.reportportal.ws.model.OperationCompletionRS;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DeleteDashboardHandlerImpl
implements DeleteDashboardHandler {
    private final GetShareableEntityHandler<Dashboard> getShareableEntityHandler;
    private final DashboardRepository dashboardRepository;
    private final DashboardWidgetRepository dashboardWidgetRepository;
    private final WidgetRepository widgetRepository;
    private final ShareableObjectsHandler aclHandler;
    private final MessageBus messageBus;

    @Autowired
    public DeleteDashboardHandlerImpl(GetShareableEntityHandler<Dashboard> getShareableEntityHandler, DashboardRepository dashboardRepository, DashboardWidgetRepository dashboardWidgetRepository, WidgetRepository widgetRepository, ShareableObjectsHandler aclHandler, MessageBus messageBus) {
        this.getShareableEntityHandler = getShareableEntityHandler;
        this.dashboardRepository = dashboardRepository;
        this.dashboardWidgetRepository = dashboardWidgetRepository;
        this.widgetRepository = widgetRepository;
        this.aclHandler = aclHandler;
        this.messageBus = messageBus;
    }

    @Override
    public OperationCompletionRS deleteDashboard(Long dashboardId, ReportPortalUser.ProjectDetails projectDetails, ReportPortalUser user) {
        Dashboard dashboard = this.getShareableEntityHandler.getAdministrated(dashboardId, projectDetails);
        Set dashboardWidgets = dashboard.getDashboardWidgets();
        List widgets = dashboardWidgets.stream().filter(DashboardWidget::isCreatedOn).map(DashboardWidget::getWidget).peek(this.aclHandler::deleteAclForObject).collect(Collectors.toList());
        dashboardWidgets.addAll(widgets.stream().flatMap(w -> w.getDashboardWidgets().stream()).collect(Collectors.toSet()));
        this.aclHandler.deleteAclForObject(dashboard);
        this.dashboardWidgetRepository.deleteAll((Iterable)dashboardWidgets);
        this.dashboardRepository.delete((Object)dashboard);
        this.widgetRepository.deleteAll(widgets);
        this.messageBus.publishActivity(new DashboardDeletedEvent(DashboardConverter.TO_ACTIVITY_RESOURCE.apply(dashboard), user.getUserId(), user.getUsername()));
        return new OperationCompletionRS("Dashboard with ID = '" + dashboardId + "' successfully deleted.");
    }
}

