/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.hierarchy.impl;

import com.epam.ta.reportportal.core.hierarchy.AbstractFinishHierarchyHandler;
import com.epam.ta.reportportal.core.item.impl.IssueTypeHandler;
import com.epam.ta.reportportal.core.item.impl.status.ChangeStatusHandler;
import com.epam.ta.reportportal.dao.IssueEntityRepository;
import com.epam.ta.reportportal.dao.ItemAttributeRepository;
import com.epam.ta.reportportal.dao.LaunchRepository;
import com.epam.ta.reportportal.dao.TestItemRepository;
import com.epam.ta.reportportal.entity.enums.StatusEnum;
import com.epam.ta.reportportal.entity.item.TestItem;
import java.math.BigInteger;
import java.util.Optional;
import java.util.stream.Stream;
import org.springframework.stereotype.Service;

@Service(value="finishTestItemHierarchyHandler")
public class FinishTestItemHierarchyHandler
extends AbstractFinishHierarchyHandler<TestItem> {
    public FinishTestItemHierarchyHandler(LaunchRepository launchRepository, TestItemRepository testItemRepository, ItemAttributeRepository itemAttributeRepository, IssueEntityRepository issueEntityRepository, IssueTypeHandler issueTypeHandler, ChangeStatusHandler changeStatusHandler) {
        super(launchRepository, testItemRepository, itemAttributeRepository, issueEntityRepository, issueTypeHandler, changeStatusHandler);
    }

    @Override
    protected boolean isIssueRequired(StatusEnum status, TestItem testItem) {
        return StatusEnum.FAILED.equals((Object)status) || Optional.ofNullable(testItem.getLaunchId()).map(launchId -> this.evaluateSkippedAttributeValue(status, (Long)launchId)).orElse(false) != false;
    }

    @Override
    protected Stream<Long> retrieveItemIds(TestItem testItem, StatusEnum status, boolean hasChildren) {
        return hasChildren ? this.testItemRepository.streamIdsByHasChildrenAndParentPathAndStatusOrderedByPathLevel(testItem.getPath(), StatusEnum.IN_PROGRESS).map(BigInteger::longValue) : this.testItemRepository.streamIdsByNotHasChildrenAndParentPathAndStatus(testItem.getPath(), status).map(BigInteger::longValue);
    }
}

