/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.integration.util;

import com.epam.reportportal.extension.bugtracking.BtsConstants;
import com.epam.reportportal.extension.bugtracking.BtsExtension;
import com.epam.ta.reportportal.commons.Predicates;
import com.epam.ta.reportportal.commons.validation.BusinessRule;
import com.epam.ta.reportportal.commons.validation.Suppliers;
import com.epam.ta.reportportal.core.integration.util.BasicIntegrationServiceImpl;
import com.epam.ta.reportportal.core.plugin.PluginBox;
import com.epam.ta.reportportal.dao.IntegrationRepository;
import com.epam.ta.reportportal.entity.integration.Integration;
import com.epam.ta.reportportal.entity.project.Project;
import com.epam.ta.reportportal.exception.ReportPortalException;
import com.epam.ta.reportportal.ws.model.ErrorType;
import java.util.Optional;
import java.util.function.Predicate;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service
public abstract class AbstractBtsIntegrationService
extends BasicIntegrationServiceImpl {
    public AbstractBtsIntegrationService(IntegrationRepository integrationRepository, PluginBox pluginBox) {
        super(integrationRepository, pluginBox);
    }

    @Override
    public boolean validateIntegration(Integration integration) {
        BtsConstants.URL.getParam(integration.getParams(), String.class).orElseThrow(() -> new ReportPortalException(ErrorType.UNABLE_INTERACT_WITH_INTEGRATION, new Object[]{"Url is not specified."}));
        BtsConstants.PROJECT.getParam(integration.getParams(), String.class).orElseThrow(() -> new ReportPortalException(ErrorType.UNABLE_INTERACT_WITH_INTEGRATION, new Object[]{"BTS project is not specified."}));
        BusinessRule.expect((Object)integration.getName(), StringUtils::isNotBlank).verify(ErrorType.BAD_REQUEST_ERROR, new Object[]{"Integration name should be specified"});
        BusinessRule.expect((Object)this.integrationRepository.existsByNameAndTypeIdAndProjectIdIsNull(integration.getName(), integration.getType().getId()), (Predicate)Predicates.equalTo((Object)Boolean.FALSE)).verify(ErrorType.INTEGRATION_ALREADY_EXISTS, new Object[]{integration.getName()});
        return true;
    }

    @Override
    public boolean validateIntegration(Integration integration, Project project) {
        BtsConstants.URL.getParam(integration.getParams(), String.class).orElseThrow(() -> new ReportPortalException(ErrorType.UNABLE_INTERACT_WITH_INTEGRATION, new Object[]{"Url is not specified."}));
        BtsConstants.PROJECT.getParam(integration.getParams(), String.class).orElseThrow(() -> new ReportPortalException(ErrorType.UNABLE_INTERACT_WITH_INTEGRATION, new Object[]{"BTS project is not specified."}));
        BusinessRule.expect((Object)integration.getName(), StringUtils::isNotBlank).verify(ErrorType.BAD_REQUEST_ERROR, new Object[]{"Integration name should be specified"});
        BusinessRule.expect((Object)this.integrationRepository.existsByNameAndTypeIdAndProjectId(integration.getName(), integration.getType().getId(), project.getId()), (Predicate)Predicates.equalTo((Object)Boolean.FALSE)).verify(ErrorType.INTEGRATION_ALREADY_EXISTS, new Object[]{integration.getName()});
        return true;
    }

    @Override
    public boolean checkConnection(Integration integration) {
        Optional<BtsExtension> extension = this.pluginBox.getInstance(integration.getType().getName(), BtsExtension.class);
        BusinessRule.expect(extension, Optional::isPresent).verify(ErrorType.UNABLE_INTERACT_WITH_INTEGRATION, new Object[]{Suppliers.formattedSupplier((String)"Could not find plugin with name '{}'.", (Object[])new Object[]{integration.getType().getName()})});
        BusinessRule.expect((Object)extension.get().testConnection(integration), BooleanUtils::isTrue).verify(ErrorType.UNABLE_INTERACT_WITH_INTEGRATION, new Object[]{"Connection refused."});
        return true;
    }
}

