/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.item.impl;

import com.epam.ta.reportportal.commons.ReportPortalUser;
import com.epam.ta.reportportal.commons.validation.BusinessRule;
import com.epam.ta.reportportal.commons.validation.BusinessRuleViolationException;
import com.epam.ta.reportportal.commons.validation.Suppliers;
import com.epam.ta.reportportal.core.analyzer.auto.LogIndexer;
import com.epam.ta.reportportal.core.analyzer.auto.impl.AnalyzerUtils;
import com.epam.ta.reportportal.core.events.MessageBus;
import com.epam.ta.reportportal.core.events.activity.ItemIssueTypeDefinedEvent;
import com.epam.ta.reportportal.core.events.activity.LinkTicketEvent;
import com.epam.ta.reportportal.core.events.activity.TestItemStatusChangedEvent;
import com.epam.ta.reportportal.core.item.ExternalTicketHandler;
import com.epam.ta.reportportal.core.item.UpdateTestItemHandler;
import com.epam.ta.reportportal.core.item.impl.IssueTypeHandler;
import com.epam.ta.reportportal.core.item.impl.status.StatusChangingStrategy;
import com.epam.ta.reportportal.dao.IssueEntityRepository;
import com.epam.ta.reportportal.dao.LaunchRepository;
import com.epam.ta.reportportal.dao.LogRepository;
import com.epam.ta.reportportal.dao.ProjectRepository;
import com.epam.ta.reportportal.dao.TestItemRepository;
import com.epam.ta.reportportal.entity.ItemAttribute;
import com.epam.ta.reportportal.entity.activity.ActivityAction;
import com.epam.ta.reportportal.entity.enums.LogLevel;
import com.epam.ta.reportportal.entity.enums.StatusEnum;
import com.epam.ta.reportportal.entity.enums.TestItemIssueGroup;
import com.epam.ta.reportportal.entity.enums.TestItemTypeEnum;
import com.epam.ta.reportportal.entity.item.TestItem;
import com.epam.ta.reportportal.entity.item.issue.IssueEntity;
import com.epam.ta.reportportal.entity.item.issue.IssueType;
import com.epam.ta.reportportal.entity.launch.Launch;
import com.epam.ta.reportportal.entity.project.Project;
import com.epam.ta.reportportal.entity.project.ProjectRole;
import com.epam.ta.reportportal.entity.user.UserRole;
import com.epam.ta.reportportal.exception.ReportPortalException;
import com.epam.ta.reportportal.util.ItemInfoUtils;
import com.epam.ta.reportportal.util.Predicates;
import com.epam.ta.reportportal.ws.converter.builders.IssueEntityBuilder;
import com.epam.ta.reportportal.ws.converter.builders.TestItemBuilder;
import com.epam.ta.reportportal.ws.converter.converters.IssueConverter;
import com.epam.ta.reportportal.ws.converter.converters.ItemAttributeConverter;
import com.epam.ta.reportportal.ws.converter.converters.TestItemConverter;
import com.epam.ta.reportportal.ws.model.BulkInfoUpdateRQ;
import com.epam.ta.reportportal.ws.model.ErrorType;
import com.epam.ta.reportportal.ws.model.OperationCompletionRS;
import com.epam.ta.reportportal.ws.model.activity.TestItemActivityResource;
import com.epam.ta.reportportal.ws.model.issue.DefineIssueRQ;
import com.epam.ta.reportportal.ws.model.issue.Issue;
import com.epam.ta.reportportal.ws.model.item.ExternalIssueRQ;
import com.epam.ta.reportportal.ws.model.item.LinkExternalIssueRQ;
import com.epam.ta.reportportal.ws.model.item.UnlinkExternalIssueRQ;
import com.epam.ta.reportportal.ws.model.item.UpdateTestItemRQ;
import com.epam.ta.reportportal.ws.model.project.AnalyzerConfig;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UpdateTestItemHandlerImpl
implements UpdateTestItemHandler {
    public static final String INITIAL_STATUS_ATTRIBUTE_KEY = "initialStatus";
    private static final String MANUALLY_CHANGED_STATUS_ATTRIBUTE_KEY = "manually";
    private final ProjectRepository projectRepository;
    private final LaunchRepository launchRepository;
    private final TestItemRepository testItemRepository;
    private final LogRepository logRepository;
    private final ExternalTicketHandler externalTicketHandler;
    private final IssueTypeHandler issueTypeHandler;
    private final MessageBus messageBus;
    private final LogIndexer logIndexer;
    private final IssueEntityRepository issueEntityRepository;
    private final Map<StatusEnum, StatusChangingStrategy> statusChangingStrategyMapping;
    private static final Function<Long, OperationCompletionRS> COMPOSE_UPDATE_RESPONSE = it -> {
        String message = (String)Suppliers.formattedSupplier((String)"TestItem with ID = '{}' successfully updated.", (Object[])new Object[]{it}).get();
        return new OperationCompletionRS(message);
    };

    @Autowired
    public UpdateTestItemHandlerImpl(ProjectRepository projectRepository, LaunchRepository launchRepository, TestItemRepository testItemRepository, LogRepository logRepository, ExternalTicketHandler externalTicketHandler, IssueTypeHandler issueTypeHandler, MessageBus messageBus, LogIndexer logIndexer, IssueEntityRepository issueEntityRepository, Map<StatusEnum, StatusChangingStrategy> statusChangingStrategyMapping) {
        this.projectRepository = projectRepository;
        this.launchRepository = launchRepository;
        this.testItemRepository = testItemRepository;
        this.logRepository = logRepository;
        this.externalTicketHandler = externalTicketHandler;
        this.issueTypeHandler = issueTypeHandler;
        this.messageBus = messageBus;
        this.logIndexer = logIndexer;
        this.issueEntityRepository = issueEntityRepository;
        this.statusChangingStrategyMapping = statusChangingStrategyMapping;
    }

    @Override
    public List<Issue> defineTestItemsIssues(ReportPortalUser.ProjectDetails projectDetails, DefineIssueRQ defineIssue, ReportPortalUser user) {
        Project project = (Project)this.projectRepository.findById((Object)projectDetails.getProjectId()).orElseThrow(() -> new ReportPortalException(ErrorType.PROJECT_NOT_FOUND, new Object[]{projectDetails.getProjectId()}));
        AnalyzerConfig analyzerConfig = AnalyzerUtils.getAnalyzerConfig(project);
        ArrayList errors = new ArrayList();
        List definitions = defineIssue.getIssues();
        BusinessRule.expect((Object)CollectionUtils.isEmpty((Collection)definitions), (Predicate)com.epam.ta.reportportal.commons.Predicates.equalTo((Object)false)).verify(ErrorType.FAILED_TEST_ITEM_ISSUE_TYPE_DEFINITION, new Object[0]);
        ArrayList<Issue> updated = new ArrayList<Issue>(defineIssue.getIssues().size());
        ArrayList events = new ArrayList();
        HashMap<Long, List> logsToReindexMap = new HashMap<Long, List>();
        ArrayList<Long> logIdsToCleanIndex = new ArrayList<Long>();
        definitions.forEach(issueDefinition -> {
            try {
                TestItem testItem = (TestItem)this.testItemRepository.findById((Object)issueDefinition.getId()).orElseThrow(() -> new BusinessRuleViolationException((String)Suppliers.formattedSupplier((String)"Cannot update issue type for test item '{}', cause it is not found.", (Object[])new Object[]{issueDefinition.getId()}).get()));
                this.verifyTestItem(testItem, issueDefinition.getId());
                TestItemActivityResource before = TestItemConverter.TO_ACTIVITY_RESOURCE.apply(testItem, projectDetails.getProjectId());
                Issue issue = issueDefinition.getIssue();
                IssueType issueType = this.issueTypeHandler.defineIssueType(projectDetails.getProjectId(), issue.getIssueType());
                IssueEntity issueEntity = new IssueEntityBuilder(testItem.getItemResults().getIssue()).addIssueType(issueType).addDescription(issue.getComment()).addIgnoreFlag(issue.getIgnoreAnalyzer()).addAutoAnalyzedFlag(issue.getAutoAnalyzed()).get();
                this.externalTicketHandler.updateLinking(user.getUsername(), issueEntity, issueDefinition.getIssue().getExternalSystemIssues());
                issueEntity.setTestItemResults(testItem.getItemResults());
                this.issueEntityRepository.save((Object)issueEntity);
                testItem.getItemResults().setIssue(issueEntity);
                this.testItemRepository.save((Object)testItem);
                if (Predicates.ITEM_CAN_BE_INDEXED.test(testItem)) {
                    Long launchId = testItem.getLaunchId();
                    Long itemId = testItem.getItemId();
                    if (logsToReindexMap.containsKey(launchId)) {
                        ((List)logsToReindexMap.get(launchId)).add(itemId);
                    } else {
                        ArrayList itemIds = Lists.newArrayList();
                        itemIds.add(itemId);
                        logsToReindexMap.put(launchId, itemIds);
                    }
                } else {
                    logIdsToCleanIndex.addAll(this.logRepository.findIdsUnderTestItemByLaunchIdAndTestItemIdsAndLogLevelGte(testItem.getLaunchId(), Collections.singletonList(testItem.getItemId()), LogLevel.ERROR.toInt()));
                }
                updated.add(IssueConverter.TO_MODEL.apply(issueEntity));
                TestItemActivityResource after = TestItemConverter.TO_ACTIVITY_RESOURCE.apply(testItem, projectDetails.getProjectId());
                events.add(new ItemIssueTypeDefinedEvent(before, after, user.getUserId(), user.getUsername()));
            }
            catch (BusinessRuleViolationException e) {
                errors.add(e.getMessage());
            }
        });
        BusinessRule.expect((Object)errors.isEmpty(), (Predicate)com.epam.ta.reportportal.commons.Predicates.equalTo((Object)Boolean.TRUE)).verify(ErrorType.FAILED_TEST_ITEM_ISSUE_TYPE_DEFINITION, new Object[]{((Object)errors).toString()});
        if (!logsToReindexMap.isEmpty()) {
            logsToReindexMap.forEach((key, value) -> this.logIndexer.indexItemsLogs(project.getId(), (Long)key, (List<Long>)value, analyzerConfig));
        }
        if (!logIdsToCleanIndex.isEmpty()) {
            this.logIndexer.cleanIndex(project.getId(), logIdsToCleanIndex);
        }
        events.forEach(this.messageBus::publishActivity);
        return updated;
    }

    @Override
    public OperationCompletionRS updateTestItem(ReportPortalUser.ProjectDetails projectDetails, Long itemId, UpdateTestItemRQ rq, ReportPortalUser user) {
        TestItem testItem = (TestItem)this.testItemRepository.findById((Object)itemId).orElseThrow(() -> new ReportPortalException(ErrorType.TEST_ITEM_NOT_FOUND, new Object[]{itemId}));
        this.validate(projectDetails, user, testItem);
        Optional providedStatus = StatusEnum.fromValue((String)rq.getStatus());
        if (providedStatus.isPresent() && !((StatusEnum)providedStatus.get()).equals((Object)testItem.getItemResults().getStatus())) {
            BusinessRule.expect((Object)(testItem.isHasChildren() && !testItem.getType().sameLevel(TestItemTypeEnum.STEP) ? 1 : 0), (Predicate)com.epam.ta.reportportal.commons.Predicates.equalTo((Object)Boolean.FALSE)).verify(ErrorType.INCORRECT_REQUEST, new Object[]{"Unable to change status on test item with children"});
            this.checkInitialStatusAttribute(testItem, rq);
            StatusChangingStrategy strategy = this.statusChangingStrategyMapping.get(providedStatus.get());
            BusinessRule.expect((Object)strategy, (Predicate)com.epam.ta.reportportal.commons.Predicates.notNull()).verify(ErrorType.INCORRECT_REQUEST, new Object[]{Suppliers.formattedSupplier((String)"Actual status: '{}' cannot be changed to '{}'.", (Object[])new Object[]{testItem.getItemResults().getStatus(), providedStatus.get()})});
            TestItemActivityResource before = TestItemConverter.TO_ACTIVITY_RESOURCE.apply(testItem, projectDetails.getProjectId());
            strategy.changeStatus(testItem, (StatusEnum)providedStatus.get(), user);
            this.messageBus.publishActivity(new TestItemStatusChangedEvent(before, TestItemConverter.TO_ACTIVITY_RESOURCE.apply(testItem, projectDetails.getProjectId()), user.getUserId(), user.getUsername()));
        }
        testItem = new TestItemBuilder(testItem).overwriteAttributes(rq.getAttributes()).addDescription(rq.getDescription()).get();
        this.testItemRepository.save((Object)testItem);
        return COMPOSE_UPDATE_RESPONSE.apply(itemId);
    }

    @Override
    public List<OperationCompletionRS> processExternalIssues(ExternalIssueRQ request, ReportPortalUser.ProjectDetails projectDetails, ReportPortalUser user) {
        ArrayList errors = new ArrayList();
        List testItems = this.testItemRepository.findAllById((Iterable)request.getTestItemIds());
        testItems.forEach(testItem -> {
            try {
                this.verifyTestItem((TestItem)testItem, testItem.getItemId());
            }
            catch (Exception e) {
                errors.add(e.getMessage());
            }
        });
        BusinessRule.expect((Object)errors.isEmpty(), (Predicate)com.epam.ta.reportportal.commons.Predicates.equalTo((Object)Boolean.TRUE)).verify(ErrorType.FAILED_TEST_ITEM_ISSUE_TYPE_DEFINITION, new Object[]{((Object)errors).toString()});
        List<TestItemActivityResource> before = testItems.stream().map(it -> TestItemConverter.TO_ACTIVITY_RESOURCE.apply((TestItem)it, projectDetails.getProjectId())).collect(Collectors.toList());
        if (LinkExternalIssueRQ.class.equals(request.getClass())) {
            LinkExternalIssueRQ linkRequest = (LinkExternalIssueRQ)request;
            this.externalTicketHandler.linkExternalTickets(user.getUsername(), testItems.stream().map(it -> it.getItemResults().getIssue()).collect(Collectors.toList()), linkRequest.getIssues());
        }
        if (UnlinkExternalIssueRQ.class.equals(request.getClass())) {
            this.externalTicketHandler.unlinkExternalTickets(testItems, (UnlinkExternalIssueRQ)request);
        }
        this.testItemRepository.saveAll((Iterable)testItems);
        List after = testItems.stream().map(it -> TestItemConverter.TO_ACTIVITY_RESOURCE.apply((TestItem)it, projectDetails.getProjectId())).collect(Collectors.toList());
        before.forEach(it -> this.messageBus.publishActivity(new LinkTicketEvent((TestItemActivityResource)it, after.stream().filter(t -> t.getId().equals(it.getId())).findFirst().get(), user.getUserId(), user.getUsername(), ActivityAction.LINK_ISSUE)));
        return testItems.stream().map(TestItem::getItemId).map(COMPOSE_UPDATE_RESPONSE).collect(Collectors.toList());
    }

    private void checkInitialStatusAttribute(TestItem item, UpdateTestItemRQ request) {
        Runnable addInitialStatusAttribute = () -> {
            ItemAttribute initialStatusAttribute = new ItemAttribute(INITIAL_STATUS_ATTRIBUTE_KEY, item.getItemResults().getStatus().getExecutionCounterField(), Boolean.valueOf(true));
            initialStatusAttribute.setTestItem(item);
            item.getAttributes().add(initialStatusAttribute);
        };
        Consumer<ItemAttribute> removeManuallyStatusAttributeIfSameAsInitial = statusAttribute -> ItemInfoUtils.extractAttributeResource(request.getAttributes(), MANUALLY_CHANGED_STATUS_ATTRIBUTE_KEY).filter(it -> it.getValue().equalsIgnoreCase(statusAttribute.getValue())).ifPresent(it -> request.getAttributes().remove(it));
        ItemInfoUtils.extractAttribute(item.getAttributes(), INITIAL_STATUS_ATTRIBUTE_KEY).ifPresentOrElse(removeManuallyStatusAttributeIfSameAsInitial, addInitialStatusAttribute);
    }

    @Override
    public void resetItemsIssue(List<Long> itemIds, Long projectId, ReportPortalUser user) {
        itemIds.forEach(itemId -> {
            TestItem item = (TestItem)this.testItemRepository.findById(itemId).orElseThrow(() -> new ReportPortalException(ErrorType.TEST_ITEM_NOT_FOUND, new Object[]{itemId}));
            TestItemActivityResource before = TestItemConverter.TO_ACTIVITY_RESOURCE.apply(item, projectId);
            IssueType issueType = this.issueTypeHandler.defineIssueType(projectId, TestItemIssueGroup.TO_INVESTIGATE.getLocator());
            IssueEntity issueEntity = new IssueEntityBuilder((IssueEntity)this.issueEntityRepository.findById(itemId).orElseThrow(() -> new ReportPortalException(ErrorType.ISSUE_TYPE_NOT_FOUND, new Object[]{itemId}))).addIssueType(issueType).addAutoAnalyzedFlag(false).get();
            this.issueEntityRepository.save((Object)issueEntity);
            item.getItemResults().setIssue(issueEntity);
            TestItemActivityResource after = TestItemConverter.TO_ACTIVITY_RESOURCE.apply(item, projectId);
            if (!StringUtils.equalsIgnoreCase((CharSequence)before.getIssueTypeLongName(), (CharSequence)after.getIssueTypeLongName())) {
                ItemIssueTypeDefinedEvent event = new ItemIssueTypeDefinedEvent(before, after, user.getUserId(), user.getUsername());
                this.messageBus.publishActivity(event);
            }
        });
    }

    @Override
    public OperationCompletionRS bulkInfoUpdate(BulkInfoUpdateRQ bulkUpdateRq, ReportPortalUser.ProjectDetails projectDetails) {
        BusinessRule.expect((Object)this.projectRepository.existsById((Object)projectDetails.getProjectId()), (Predicate)com.epam.ta.reportportal.commons.Predicates.equalTo((Object)Boolean.TRUE)).verify(ErrorType.PROJECT_NOT_FOUND, new Object[]{projectDetails.getProjectId()});
        List items = this.testItemRepository.findAllById((Iterable)bulkUpdateRq.getIds());
        items.forEach(it -> ItemInfoUtils.updateDescription(bulkUpdateRq.getDescription(), it.getDescription()).ifPresent(arg_0 -> ((TestItem)it).setDescription(arg_0)));
        bulkUpdateRq.getAttributes().forEach(it -> {
            switch (it.getAction()) {
                case DELETE: {
                    items.forEach(item -> {
                        ItemAttribute toDelete = ItemInfoUtils.findAttributeByResource(item.getAttributes(), it.getFrom());
                        item.getAttributes().remove(toDelete);
                    });
                    break;
                }
                case UPDATE: {
                    items.forEach(item -> ItemInfoUtils.updateAttribute(item.getAttributes(), it));
                    break;
                }
                case CREATE: {
                    items.stream().filter(item -> ItemInfoUtils.containsAttribute(item.getAttributes(), it.getTo())).forEach(item -> {
                        ItemAttribute itemAttribute = ItemAttributeConverter.FROM_RESOURCE.apply(it.getTo());
                        itemAttribute.setTestItem(item);
                        item.getAttributes().add(itemAttribute);
                    });
                }
            }
        });
        return new OperationCompletionRS("Attributes successfully updated");
    }

    private void validate(ReportPortalUser.ProjectDetails projectDetails, ReportPortalUser user, TestItem testItem) {
        Launch launch = (Launch)this.launchRepository.findById((Object)testItem.getLaunchId()).orElseThrow(() -> new ReportPortalException(ErrorType.LAUNCH_NOT_FOUND, new Object[]{testItem.getLaunchId()}));
        if (user.getUserRole() != UserRole.ADMINISTRATOR) {
            BusinessRule.expect((Object)launch.getProjectId(), (Predicate)com.epam.ta.reportportal.commons.Predicates.equalTo((Object)projectDetails.getProjectId())).verify(ErrorType.ACCESS_DENIED, new Object[]{"Launch is not under the specified project."});
            if (projectDetails.getProjectRole().lowerThan(ProjectRole.PROJECT_MANAGER)) {
                BusinessRule.expect((Object)user.getUserId(), Predicate.isEqual(launch.getUserId())).verify(ErrorType.ACCESS_DENIED, new Object[]{"You are not a launch owner."});
            }
        }
    }

    private void verifyTestItem(TestItem item, Long id) throws BusinessRuleViolationException {
        BusinessRule.expect((Object)item.getItemResults(), (Predicate)com.epam.ta.reportportal.commons.Predicates.notNull(), (Supplier)Suppliers.formattedSupplier((String)"Test item results were not found for test item with id = '{}", (Object[])new Object[]{item.getItemId()})).verify();
        BusinessRule.expect((Object)item.getItemResults().getStatus(), (Predicate)com.epam.ta.reportportal.commons.Predicates.not((Predicate)com.epam.ta.reportportal.commons.Predicates.equalTo((Object)StatusEnum.PASSED)), (Supplier)Suppliers.formattedSupplier((String)"Issue status update cannot be applied on {} test items, cause it is not allowed.", (Object[])new Object[]{StatusEnum.PASSED.name()})).verify();
        BusinessRule.expect((Object)item.isHasChildren(), (Predicate)com.epam.ta.reportportal.commons.Predicates.equalTo((Object)Boolean.FALSE), (Supplier)Suppliers.formattedSupplier((String)"It is not allowed to update issue type for items with descendants. Test item '{}' has descendants.", (Object[])new Object[]{id})).verify();
        BusinessRule.expect((Object)item.getItemResults().getIssue(), (Predicate)com.epam.ta.reportportal.commons.Predicates.notNull(), (Supplier)Suppliers.formattedSupplier((String)"Cannot update issue type for test item '{}', cause there is no info about actual issue type value.", (Object[])new Object[]{id})).verify();
        BusinessRule.expect((Object)item.getItemResults().getIssue().getIssueType(), (Predicate)com.epam.ta.reportportal.commons.Predicates.notNull(), (Supplier)Suppliers.formattedSupplier((String)"Cannot update issue type for test item {}, cause it's actual issue type value is not provided.", (Object[])new Object[]{id})).verify();
    }
}

