/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.item.impl.status;

import com.epam.ta.reportportal.commons.Preconditions;
import com.epam.ta.reportportal.commons.ReportPortalUser;
import com.epam.ta.reportportal.commons.validation.BusinessRule;
import com.epam.ta.reportportal.commons.validation.Suppliers;
import com.epam.ta.reportportal.core.analyzer.auto.LogIndexer;
import com.epam.ta.reportportal.core.events.MessageBus;
import com.epam.ta.reportportal.core.item.impl.IssueTypeHandler;
import com.epam.ta.reportportal.core.item.impl.status.AbstractStatusChangingStrategy;
import com.epam.ta.reportportal.dao.IssueEntityRepository;
import com.epam.ta.reportportal.dao.LaunchRepository;
import com.epam.ta.reportportal.dao.LogRepository;
import com.epam.ta.reportportal.dao.ProjectRepository;
import com.epam.ta.reportportal.dao.TestItemRepository;
import com.epam.ta.reportportal.entity.enums.LogLevel;
import com.epam.ta.reportportal.entity.enums.StatusEnum;
import com.epam.ta.reportportal.entity.item.TestItem;
import com.epam.ta.reportportal.entity.launch.Launch;
import com.epam.ta.reportportal.entity.project.Project;
import com.epam.ta.reportportal.ws.model.ErrorType;
import java.util.Collections;
import java.util.Optional;
import java.util.function.Predicate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ToPassedStatusChangingStrategy
extends AbstractStatusChangingStrategy {
    private final TestItemRepository testItemRepository;

    @Autowired
    protected ToPassedStatusChangingStrategy(ProjectRepository projectRepository, LaunchRepository launchRepository, IssueTypeHandler issueTypeHandler, MessageBus messageBus, IssueEntityRepository issueEntityRepository, LogRepository logRepository, LogIndexer logIndexer, TestItemRepository testItemRepository) {
        super(projectRepository, launchRepository, issueTypeHandler, messageBus, issueEntityRepository, logRepository, logIndexer);
        this.testItemRepository = testItemRepository;
    }

    @Override
    protected void updateStatus(Project project, Launch launch, TestItem testItem, StatusEnum providedStatus, ReportPortalUser user) {
        BusinessRule.expect((Object)providedStatus, (Predicate)Preconditions.statusIn((StatusEnum[])new StatusEnum[]{StatusEnum.PASSED})).verify(ErrorType.INCORRECT_REQUEST, new Object[]{Suppliers.formattedSupplier((String)"Incorrect status - '{}', only '{}' is allowed", (Object[])new Object[]{providedStatus, StatusEnum.PASSED}).get()});
        testItem.getItemResults().setStatus(providedStatus);
        Optional.ofNullable(testItem.getItemResults().getIssue()).ifPresent(issue -> {
            issue.setTestItemResults(null);
            this.issueEntityRepository.delete(issue);
            testItem.getItemResults().setIssue(null);
            this.logIndexer.cleanIndex(project.getId(), this.logRepository.findIdsUnderTestItemByLaunchIdAndTestItemIdsAndLogLevelGte(testItem.getLaunchId(), Collections.singletonList(testItem.getItemId()), LogLevel.ERROR.toInt()));
        });
        this.changeParentsStatuses(testItem, launch, false, user);
    }

    @Override
    protected StatusEnum evaluateParentItemStatus(TestItem parentItem, TestItem childItem) {
        return this.testItemRepository.hasStatusNotEqualsWithoutStepItem(parentItem.getItemId(), childItem.getItemId(), StatusEnum.PASSED) ? StatusEnum.FAILED : StatusEnum.PASSED;
    }
}

