/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.shareable.impl;

import com.epam.ta.reportportal.commons.ReportPortalUser;
import com.epam.ta.reportportal.core.shareable.GetShareableEntityHandler;
import com.epam.ta.reportportal.dao.DashboardRepository;
import com.epam.ta.reportportal.entity.dashboard.Dashboard;
import com.epam.ta.reportportal.exception.ReportPortalException;
import com.epam.ta.reportportal.ws.model.ErrorType;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PostAuthorize;
import org.springframework.stereotype.Service;

@Service
public class GetShareableDashboardHandlerImpl
implements GetShareableEntityHandler<Dashboard> {
    private final DashboardRepository dashboardRepository;

    @Autowired
    public GetShareableDashboardHandlerImpl(DashboardRepository dashboardRepository) {
        this.dashboardRepository = dashboardRepository;
    }

    @Override
    @PostAuthorize(value="hasPermission(returnObject, 'aclReadPermission') || hasPermission(returnObject, 'aclFullPermission') || hasRole('ADMINISTRATOR') || hasPermission(#projectDetails.getProjectName().toLowerCase(), 'projectManagerPermission')")
    public Dashboard getPermitted(Long id, ReportPortalUser.ProjectDetails projectDetails) {
        return (Dashboard)this.dashboardRepository.findByIdAndProjectId(id, projectDetails.getProjectId()).orElseThrow(() -> new ReportPortalException(ErrorType.DASHBOARD_NOT_FOUND_IN_PROJECT, new Object[]{id, projectDetails.getProjectName()}));
    }

    @Override
    @PostAuthorize(value="hasPermission(returnObject, 'aclFullPermission') || hasRole('ADMINISTRATOR') || hasPermission(#projectDetails.getProjectName().toLowerCase(), 'projectManagerPermission')")
    public Dashboard getAdministrated(Long id, ReportPortalUser.ProjectDetails projectDetails) {
        return (Dashboard)this.dashboardRepository.findByIdAndProjectId(id, projectDetails.getProjectId()).orElseThrow(() -> new ReportPortalException(ErrorType.DASHBOARD_NOT_FOUND_IN_PROJECT, new Object[]{id, projectDetails.getProjectName()}));
    }
}

