/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.shareable.impl;

import com.epam.ta.reportportal.commons.ReportPortalUser;
import com.epam.ta.reportportal.core.shareable.GetShareableEntityHandler;
import com.epam.ta.reportportal.dao.UserFilterRepository;
import com.epam.ta.reportportal.entity.filter.UserFilter;
import com.epam.ta.reportportal.exception.ReportPortalException;
import com.epam.ta.reportportal.ws.model.ErrorType;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PostAuthorize;
import org.springframework.stereotype.Service;

@Service
public class GetShareableFilterHandlerImpl
implements GetShareableEntityHandler<UserFilter> {
    private final UserFilterRepository filterRepository;

    @Autowired
    public GetShareableFilterHandlerImpl(UserFilterRepository filterRepository) {
        this.filterRepository = filterRepository;
    }

    @Override
    @PostAuthorize(value="hasPermission(returnObject, 'aclReadPermission') || hasPermission(returnObject, 'aclFullPermission') || hasRole('ADMINISTRATOR') || hasPermission(#projectDetails.getProjectName().toLowerCase(), 'projectManagerPermission')")
    public UserFilter getPermitted(Long id, ReportPortalUser.ProjectDetails projectDetails) {
        return (UserFilter)this.filterRepository.findByIdAndProjectId(id, projectDetails.getProjectId()).orElseThrow(() -> new ReportPortalException(ErrorType.USER_FILTER_NOT_FOUND_IN_PROJECT, new Object[]{id, projectDetails.getProjectName()}));
    }

    @Override
    @PostAuthorize(value="hasPermission(returnObject, 'aclFullPermission') || hasRole('ADMINISTRATOR') || hasPermission(#projectDetails.getProjectName().toLowerCase(), 'projectManagerPermission')")
    public UserFilter getAdministrated(Long id, ReportPortalUser.ProjectDetails projectDetails) {
        return (UserFilter)this.filterRepository.findByIdAndProjectId(id, projectDetails.getProjectId()).orElseThrow(() -> new ReportPortalException(ErrorType.USER_FILTER_NOT_FOUND_IN_PROJECT, new Object[]{id, projectDetails.getProjectName()}));
    }
}

