/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.widget.content.filter;

import com.epam.ta.reportportal.commons.querygen.Condition;
import com.epam.ta.reportportal.commons.querygen.ConvertibleCondition;
import com.epam.ta.reportportal.commons.querygen.Filter;
import com.epam.ta.reportportal.commons.querygen.FilterCondition;
import com.epam.ta.reportportal.core.widget.content.filter.AbstractStatisticsFilterStrategy;
import com.epam.ta.reportportal.entity.launch.Launch;
import com.epam.ta.reportportal.entity.widget.Widget;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;

@Service(value="productStatusFilterStrategy")
public class ProductStatusFilterStrategy
extends AbstractStatisticsFilterStrategy {
    @Override
    protected Map<Filter, Sort> buildFilterSortMap(Widget widget, Long projectId) {
        LinkedHashMap filterSortMap = Maps.newLinkedHashMap();
        Optional.ofNullable(widget.getFilters()).orElse(Collections.emptySet()).forEach(userFilter -> {
            Filter filter = new Filter(userFilter.getId(), userFilter.getTargetClass().getClassObject(), (List)Lists.newArrayList((Iterable)userFilter.getFilterCondition()));
            filter.withConditions(this.buildDefaultFilter(widget, projectId).getFilterConditions());
            Optional<Set> filterSorts = Optional.ofNullable(userFilter.getFilterSorts());
            Sort sort = Sort.by((List)filterSorts.map(filterSort -> filterSort.stream().map(s -> Sort.Order.by((String)s.getField()).with(s.getDirection())).collect(Collectors.toList())).orElseGet(Collections::emptyList));
            filterSortMap.put(filter, sort);
        });
        return filterSortMap;
    }

    @Override
    protected Filter buildDefaultFilter(Widget widget, Long projectId) {
        return new Filter(Launch.class, (List)Lists.newArrayList((Object[])new ConvertibleCondition[]{new FilterCondition(Condition.EQUALS, false, String.valueOf(projectId), "projectId")}));
    }
}

