/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.widget.content.loader;

import com.epam.ta.reportportal.commons.Predicates;
import com.epam.ta.reportportal.commons.querygen.Condition;
import com.epam.ta.reportportal.commons.querygen.ConvertibleCondition;
import com.epam.ta.reportportal.commons.querygen.Filter;
import com.epam.ta.reportportal.commons.querygen.FilterCondition;
import com.epam.ta.reportportal.commons.validation.BusinessRule;
import com.epam.ta.reportportal.core.widget.content.LoadContentStrategy;
import com.epam.ta.reportportal.core.widget.util.WidgetFilterUtil;
import com.epam.ta.reportportal.core.widget.util.WidgetOptionUtil;
import com.epam.ta.reportportal.dao.LaunchRepository;
import com.epam.ta.reportportal.dao.WidgetContentRepository;
import com.epam.ta.reportportal.entity.launch.Launch;
import com.epam.ta.reportportal.entity.widget.WidgetOptions;
import com.epam.ta.reportportal.entity.widget.content.PassingRateStatisticsResult;
import com.epam.ta.reportportal.exception.ReportPortalException;
import com.epam.ta.reportportal.ws.model.ErrorType;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;

@Service
public class PassingRatePerLaunchContentLoader
implements LoadContentStrategy {
    @Autowired
    private LaunchRepository launchRepository;
    @Autowired
    private WidgetContentRepository widgetContentRepository;

    @Override
    public Map<String, ?> loadContent(List<String> contentFields, Map<Filter, Sort> filterSortMapping, WidgetOptions widgetOptions, int limit) {
        this.validateFilterSortMapping(filterSortMapping);
        this.validateWidgetOptions(widgetOptions);
        String launchName = WidgetOptionUtil.getValueByKey("launchNameFilter", widgetOptions);
        Filter filter = WidgetFilterUtil.GROUP_FILTERS.apply(filterSortMapping.keySet());
        Sort sort = WidgetFilterUtil.GROUP_SORTS.apply(filterSortMapping.values());
        Launch latestLaunch = (Launch)this.launchRepository.findLatestByFilter(filter.withCondition((ConvertibleCondition)new FilterCondition(Condition.EQUALS, false, launchName, "name"))).orElseThrow(() -> new ReportPortalException(ErrorType.LAUNCH_NOT_FOUND, new Object[]{"No launch with name: " + launchName}));
        filter.withCondition((ConvertibleCondition)new FilterCondition(Condition.EQUALS, false, String.valueOf(latestLaunch.getId()), "id"));
        PassingRateStatisticsResult result = this.widgetContentRepository.passingRatePerLaunchStatistics(filter, sort, limit);
        return result.getTotal() != 0 ? Collections.singletonMap("result", result) : Collections.emptyMap();
    }

    private void validateFilterSortMapping(Map<Filter, Sort> filterSortMapping) {
        BusinessRule.expect((Object)MapUtils.isNotEmpty(filterSortMapping), (Predicate)Predicates.equalTo((Object)true)).verify(ErrorType.BAD_REQUEST_ERROR, new Object[]{"Filter-Sort mapping should not be empty"});
    }

    private void validateWidgetOptions(WidgetOptions widgetOptions) {
        BusinessRule.expect((Object)WidgetOptionUtil.getValueByKey("launchNameFilter", widgetOptions), StringUtils::isNotEmpty).verify(ErrorType.UNABLE_LOAD_WIDGET_CONTENT, new Object[]{"launchNameFilter should be specified for widget."});
    }
}

