/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.widget.content.loader.util;

import com.epam.ta.reportportal.commons.querygen.Condition;
import com.epam.ta.reportportal.commons.querygen.ConvertibleCondition;
import com.epam.ta.reportportal.commons.querygen.Filter;
import com.epam.ta.reportportal.commons.querygen.FilterCondition;
import com.epam.ta.reportportal.entity.launch.Launch;
import com.epam.ta.reportportal.exception.ReportPortalException;
import com.epam.ta.reportportal.ws.model.ErrorType;
import java.util.Collection;

public final class FilterUtils {
    private FilterUtils() {
    }

    public static Filter buildLatestLaunchFilter(Long projectId, String launchName) {
        return Filter.builder().withTarget(Launch.class).withCondition((ConvertibleCondition)new FilterCondition(Condition.EQUALS, false, String.valueOf(projectId), "projectId")).withCondition((ConvertibleCondition)new FilterCondition(Condition.EQUALS, false, launchName, "name")).build();
    }

    public static Filter buildLatestLaunchFilter(Filter filter, String launchName) {
        return FilterUtils.buildLatestLaunchFilter(filter.getFilterConditions().stream().map(ConvertibleCondition::getAllConditions).flatMap(Collection::stream).filter(condition -> "projectId".equalsIgnoreCase(condition.getSearchCriteria())).map(condition -> Long.parseLong(condition.getValue())).findAny().orElseThrow(() -> new ReportPortalException(ErrorType.INCORRECT_FILTER_PARAMETERS, new Object[]{"Project id should be specified."})), launchName);
    }
}

