/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.demodata.service;

import com.epam.ta.reportportal.commons.ReportPortalUser;
import com.epam.ta.reportportal.dao.UserRepository;
import com.epam.ta.reportportal.demodata.model.DemoDataRq;
import com.epam.ta.reportportal.demodata.model.DemoItemMetadata;
import com.epam.ta.reportportal.demodata.service.ContentUtils;
import com.epam.ta.reportportal.demodata.service.DemoDataFacade;
import com.epam.ta.reportportal.demodata.service.DemoDataLaunchService;
import com.epam.ta.reportportal.demodata.service.DemoDataTestItemService;
import com.epam.ta.reportportal.demodata.service.DemoLogsService;
import com.epam.ta.reportportal.entity.enums.StatusEnum;
import com.epam.ta.reportportal.entity.enums.TestItemTypeEnum;
import com.epam.ta.reportportal.entity.launch.Launch;
import com.epam.ta.reportportal.entity.log.Log;
import com.epam.ta.reportportal.entity.user.User;
import com.epam.ta.reportportal.exception.ReportPortalException;
import com.epam.ta.reportportal.ws.model.ErrorType;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.Resource;
import org.springframework.core.task.TaskExecutor;
import org.springframework.stereotype.Service;

@Service
public class DefaultDemoDataFacade
implements DemoDataFacade {
    private final DemoDataLaunchService demoDataLaunchService;
    private final DemoDataTestItemService demoDataTestItemService;
    private final DemoLogsService demoLogsService;
    private final ObjectMapper objectMapper;
    private final UserRepository userRepository;
    private final TaskExecutor executor;
    @Value(value="classpath:demo/demo_data.json")
    private Resource resource;

    public DefaultDemoDataFacade(DemoDataLaunchService demoDataLaunchService, DemoDataTestItemService demoDataTestItemService, DemoLogsService demoLogsService, ObjectMapper objectMapper, UserRepository userRepository, @Qualifier(value="demoDataTaskExecutor") TaskExecutor executor) {
        this.demoDataLaunchService = demoDataLaunchService;
        this.demoDataTestItemService = demoDataTestItemService;
        this.demoLogsService = demoLogsService;
        this.objectMapper = objectMapper;
        this.userRepository = userRepository;
        this.executor = executor;
    }

    @Override
    public List<Long> generateDemoLaunches(DemoDataRq demoDataRq, ReportPortalUser user, ReportPortalUser.ProjectDetails projectDetails) {
        Map suites;
        try {
            suites = (Map)this.objectMapper.readValue(this.resource.getURL(), (TypeReference)new TypeReference<Map<String, Map<String, List<String>>>>(){});
        }
        catch (IOException e) {
            throw new ReportPortalException("Unable to load suites description. " + e.getMessage(), (Throwable)e);
        }
        return this.generateLaunches(demoDataRq, suites, user, projectDetails);
    }

    private List<Long> generateLaunches(DemoDataRq rq, Map<String, Map<String, List<String>>> suitesStructure, ReportPortalUser user, ReportPortalUser.ProjectDetails projectDetails) {
        User creator = (User)this.userRepository.findById((Object)user.getUserId()).orElseThrow(() -> new ReportPortalException(ErrorType.USER_NOT_FOUND, new Object[]{user.getUsername()}));
        List futures = IntStream.range(0, rq.getLaunchesQuantity()).mapToObj(i -> CompletableFuture.supplyAsync(() -> {
            Launch launch = this.demoDataLaunchService.startLaunch("Demo Api Tests", i, creator, projectDetails);
            this.generateSuites(suitesStructure, i, launch.getUuid(), user, projectDetails);
            this.demoDataLaunchService.finishLaunch(launch.getUuid());
            List<Log> logs = this.demoLogsService.generateDemoLaunchLogs(launch.getUuid(), launch.getStatus());
            this.demoLogsService.attachFiles(logs, projectDetails.getProjectId(), launch.getUuid());
            return launch.getId();
        }, (Executor)this.executor)).collect(Collectors.toList());
        return futures.stream().map(CompletableFuture::join).collect(Collectors.toList());
    }

    private void generateSuites(Map<String, Map<String, List<String>>> suitesStructure, int i, String launchId, ReportPortalUser user, ReportPortalUser.ProjectDetails projectDetails) {
        suitesStructure.entrySet().stream().limit(i + 1).forEach(suites -> {
            DemoItemMetadata metadata = new DemoItemMetadata().withLaunch(launchId).withName((String)suites.getKey()).withType(TestItemTypeEnum.SUITE).withUser(user).withProjectDetails(projectDetails);
            String suiteItemId = this.demoDataTestItemService.startRootItem(metadata);
            boolean generateNestedSteps = ContentUtils.getWithProbability(30);
            StringBuilder nestedStepIdBuilder = new StringBuilder();
            if (generateNestedSteps) {
                metadata.withName("Test with nested steps").withParentId(suiteItemId).withType(TestItemTypeEnum.TEST);
                nestedStepIdBuilder.append(this.demoDataTestItemService.startTestItem(metadata));
            }
            ((Map)suites.getValue()).forEach((key, value) -> {
                boolean generateClass = ContentUtils.getWithProbability(30);
                boolean generateBeforeMethod = ContentUtils.getWithProbability(30);
                boolean generateAfterMethod = ContentUtils.getWithProbability(30);
                metadata.withName((String)key).withParentId(nestedStepIdBuilder.length() > 0 ? nestedStepIdBuilder.toString() : suiteItemId).withType(generateNestedSteps ? TestItemTypeEnum.STEP : TestItemTypeEnum.TEST).withRetry(false);
                String testItemId = this.demoDataTestItemService.startTestItem(metadata);
                Optional<Object> beforeClassStatus = Optional.empty();
                if (!generateNestedSteps && generateClass) {
                    beforeClassStatus = Optional.of(this.status());
                    metadata.withParentId(testItemId).withType(TestItemTypeEnum.BEFORE_CLASS).withName(ContentUtils.getNameFromType(TestItemTypeEnum.BEFORE_CLASS));
                    this.generateStepItem(metadata, (StatusEnum)beforeClassStatus.get());
                }
                value.stream().limit(generateNestedSteps ? (long)value.size() : (long)(i + 1)).forEach(name -> {
                    if (!generateNestedSteps && generateBeforeMethod) {
                        metadata.withType(TestItemTypeEnum.BEFORE_METHOD).withName(ContentUtils.getNameFromType(TestItemTypeEnum.BEFORE_METHOD)).withParentId(testItemId);
                        this.generateStepItem(metadata, this.status());
                    }
                    StatusEnum status = this.status();
                    metadata.withName((String)name).withType(TestItemTypeEnum.STEP).withParentId(testItemId).withNested(generateNestedSteps);
                    this.generateStepWithLogs(metadata, status);
                    if (!generateNestedSteps) {
                        this.generateRetries(metadata, status);
                    }
                    if (!generateNestedSteps && generateAfterMethod) {
                        metadata.withType(TestItemTypeEnum.AFTER_METHOD).withName(ContentUtils.getNameFromType(TestItemTypeEnum.AFTER_METHOD)).withParentId(testItemId);
                        this.generateStepItem(metadata, this.status());
                    }
                });
                if (generateNestedSteps) {
                    metadata.withNested(false);
                }
                if (!generateNestedSteps && generateClass) {
                    metadata.withType(TestItemTypeEnum.AFTER_CLASS).withName(ContentUtils.getNameFromType(TestItemTypeEnum.AFTER_CLASS)).withParentId(suiteItemId);
                    this.generateStepItem(metadata, this.status());
                }
                StatusEnum status = (StatusEnum)beforeClassStatus.orElse(StatusEnum.FAILED);
                this.demoDataTestItemService.finishTestItem(testItemId, status, user, projectDetails);
                if (ContentUtils.getWithProbability(30)) {
                    this.generateLogs(testItemId, launchId, status, projectDetails);
                }
            });
            if (generateNestedSteps) {
                this.demoDataTestItemService.finishTestItem(nestedStepIdBuilder.toString(), null, user, projectDetails);
            }
            this.demoDataTestItemService.finishRootItem(suiteItemId, user, projectDetails);
            if (ContentUtils.getWithProbability(30)) {
                this.generateLogs(suiteItemId, launchId, StatusEnum.PASSED, projectDetails);
            }
        });
    }

    private void generateRetries(DemoItemMetadata metadata, StatusEnum status) {
        if (status != StatusEnum.PASSED && ContentUtils.getWithProbability(60)) {
            while ((status = this.status()) != StatusEnum.PASSED) {
                metadata.withRetry(true);
                this.generateStepWithLogs(metadata, status);
            }
        }
        metadata.withRetry(false);
    }

    private void generateStepWithLogs(DemoItemMetadata metadata, StatusEnum status) {
        String stepId = this.demoDataTestItemService.startTestItem(metadata);
        this.generateLogs(stepId, metadata.getLaunchId(), status, metadata.getProjectDetails());
        this.demoDataTestItemService.finishTestItem(stepId, status, metadata.getUser(), metadata.getProjectDetails());
    }

    private void generateLogs(String itemId, String launchId, StatusEnum status, ReportPortalUser.ProjectDetails projectDetails) {
        List<Log> logs = this.demoLogsService.generateDemoLogs(itemId, status);
        this.demoLogsService.attachFiles(logs, projectDetails.getProjectId(), itemId, launchId);
    }

    private void generateStepItem(DemoItemMetadata metadata, StatusEnum status) {
        String beforeMethodId = this.demoDataTestItemService.startTestItem(metadata);
        this.demoDataTestItemService.finishTestItem(beforeMethodId, status, metadata.getUser(), metadata.getProjectDetails());
    }

    private StatusEnum status() {
        int STATUS_PROBABILITY = 15;
        if (ContentUtils.getWithProbability(STATUS_PROBABILITY)) {
            return StatusEnum.SKIPPED;
        }
        if (ContentUtils.getWithProbability(2 * STATUS_PROBABILITY)) {
            return StatusEnum.FAILED;
        }
        return StatusEnum.PASSED;
    }
}

