/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.demodata.service;

import com.epam.ta.reportportal.commons.ReportPortalUser;
import com.epam.ta.reportportal.dao.LaunchRepository;
import com.epam.ta.reportportal.dao.TestItemRepository;
import com.epam.ta.reportportal.demodata.service.ContentUtils;
import com.epam.ta.reportportal.entity.enums.StatusEnum;
import com.epam.ta.reportportal.entity.launch.Launch;
import com.epam.ta.reportportal.entity.user.User;
import com.epam.ta.reportportal.exception.ReportPortalException;
import com.epam.ta.reportportal.ws.converter.builders.LaunchBuilder;
import com.epam.ta.reportportal.ws.model.ErrorType;
import com.epam.ta.reportportal.ws.model.attribute.ItemAttributesRQ;
import com.epam.ta.reportportal.ws.model.launch.Mode;
import com.epam.ta.reportportal.ws.model.launch.StartLaunchRQ;
import com.google.common.collect.Sets;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Date;
import java.util.HashSet;
import java.util.Random;
import java.util.UUID;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DemoDataLaunchService {
    private final LaunchRepository launchRepository;
    private final TestItemRepository testItemRepository;
    private static final LocalDateTime lastLaunchTime = LocalDateTime.now();
    private String[] platformValues = new String[]{"linux", "windows", "macos", "ios", "android", "windows mobile", "ubuntu", "mint", "arch", "windows 10", "windows 7", "windows server", "debian", "alpine"};

    @Autowired
    public DemoDataLaunchService(LaunchRepository launchRepository, TestItemRepository testItemRepository) {
        this.launchRepository = launchRepository;
        this.testItemRepository = testItemRepository;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional
    public Launch startLaunch(String name, int i, User user, ReportPortalUser.ProjectDetails projectDetails) {
        LocalDateTime localDateTime = lastLaunchTime;
        synchronized (localDateTime) {
            StartLaunchRQ rq = new StartLaunchRQ();
            rq.setMode(Mode.DEFAULT);
            rq.setDescription(ContentUtils.getLaunchDescription());
            LocalDateTime now = LocalDateTime.now();
            rq.setName(name);
            if (now.isAfter(lastLaunchTime)) {
                rq.setStartTime(Date.from(now.atZone(ZoneId.systemDefault()).toInstant()));
            } else {
                rq.setStartTime(Date.from(lastLaunchTime.plusSeconds(3L).atZone(ZoneId.systemDefault()).toInstant()));
            }
            rq.setUuid(UUID.randomUUID().toString());
            HashSet attributes = Sets.newHashSet((Object[])new ItemAttributesRQ[]{new ItemAttributesRQ("platform", this.platformValues[new Random().nextInt(this.platformValues.length)]), new ItemAttributesRQ(null, "demo"), new ItemAttributesRQ("build", "3." + now.getDayOfMonth() + "." + now.getHour() + "." + i)});
            Launch launch = new LaunchBuilder().addStartRQ(rq).addAttributes(attributes).addProject(projectDetails.getProjectId()).get();
            launch.setUserId(user.getId());
            this.launchRepository.save((Object)launch);
            this.launchRepository.refresh((Object)launch);
            if (launch.getStartTime().isAfter(lastLaunchTime)) {
                lastLaunchTime.with(launch.getStartTime());
            }
            return launch;
        }
    }

    @Transactional
    public void finishLaunch(String launchId) {
        Launch launch = (Launch)this.launchRepository.findByUuid(launchId).orElseThrow(() -> new ReportPortalException(ErrorType.LAUNCH_NOT_FOUND, new Object[]{launchId}));
        if (this.testItemRepository.hasItemsInStatusByLaunch(launch.getId(), new StatusEnum[]{StatusEnum.IN_PROGRESS}).booleanValue()) {
            this.testItemRepository.interruptInProgressItems(launch.getId());
        }
        launch = new LaunchBuilder(launch).addEndTime(new Date()).get();
        StatusEnum fromStatisticsStatus = StatusEnum.PASSED;
        if (this.launchRepository.hasRootItemsWithStatusNotEqual(launch.getId(), StatusEnum.PASSED)) {
            fromStatisticsStatus = StatusEnum.FAILED;
        }
        launch.setStatus(fromStatisticsStatus);
        this.launchRepository.save((Object)launch);
    }
}

