/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.demodata.service;

import com.epam.ta.reportportal.commons.ReportPortalUser;
import com.epam.ta.reportportal.core.item.FinishTestItemHandler;
import com.epam.ta.reportportal.core.item.StartTestItemHandler;
import com.epam.ta.reportportal.demodata.model.DemoItemMetadata;
import com.epam.ta.reportportal.demodata.service.ContentUtils;
import com.epam.ta.reportportal.entity.enums.StatusEnum;
import com.epam.ta.reportportal.entity.enums.TestItemTypeEnum;
import com.epam.ta.reportportal.ws.model.FinishTestItemRQ;
import com.epam.ta.reportportal.ws.model.StartTestItemRQ;
import com.epam.ta.reportportal.ws.model.issue.Issue;
import java.util.Date;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DemoDataTestItemService {
    private final StartTestItemHandler startTestItemHandler;
    private final FinishTestItemHandler finishTestItemHandler;

    @Autowired
    public DemoDataTestItemService(StartTestItemHandler startTestItemHandler, FinishTestItemHandler finishTestItemHandler) {
        this.startTestItemHandler = startTestItemHandler;
        this.finishTestItemHandler = finishTestItemHandler;
    }

    @Transactional
    public String startRootItem(DemoItemMetadata metadata) {
        StartTestItemRQ rq = new StartTestItemRQ();
        rq.setName(metadata.getName());
        rq.setCodeRef("com.epam.ta.reportportal.demodata." + metadata.getName());
        rq.setLaunchUuid(metadata.getLaunchId());
        rq.setStartTime(new Date());
        rq.setType(metadata.getType().name());
        if (metadata.getType().sameLevel(TestItemTypeEnum.SUITE) && ContentUtils.getWithProbability(60)) {
            rq.setAttributes(ContentUtils.getAttributesInRange(3));
            rq.setDescription(ContentUtils.getSuiteDescription());
        }
        return this.startTestItemHandler.startRootItem(metadata.getUser(), metadata.getProjectDetails(), rq).getId();
    }

    @Transactional
    public void finishRootItem(String rootItemId, ReportPortalUser user, ReportPortalUser.ProjectDetails projectDetails) {
        FinishTestItemRQ rq = new FinishTestItemRQ();
        rq.setEndTime(new Date());
        this.finishTestItemHandler.finishTestItem(user, projectDetails, rootItemId, rq);
    }

    @Transactional
    public String startTestItem(DemoItemMetadata metadata) {
        StartTestItemRQ rq = new StartTestItemRQ();
        if (ContentUtils.getWithProbability(60)) {
            if (this.hasChildren(metadata.getType())) {
                rq.setAttributes(ContentUtils.getAttributesInRange(3));
                rq.setDescription(ContentUtils.getTestDescription());
            } else {
                rq.setAttributes(ContentUtils.getAttributesInRange(3));
                rq.setDescription(ContentUtils.getStepDescription());
            }
        }
        rq.setHasStats(!metadata.isNested());
        rq.setCodeRef("com.epam.ta.reportportal.demodata." + metadata.getName());
        rq.setRetry(Boolean.valueOf(metadata.isRetry()));
        rq.setLaunchUuid(metadata.getLaunchId());
        rq.setStartTime(new Date());
        rq.setName(metadata.getName());
        rq.setType(metadata.getType().name());
        return this.startTestItemHandler.startChildItem(metadata.getUser(), metadata.getProjectDetails(), rq, metadata.getParentId()).getId();
    }

    @Transactional
    public void finishTestItem(String testItemId, StatusEnum status, ReportPortalUser user, ReportPortalUser.ProjectDetails projectDetails) {
        FinishTestItemRQ rq = new FinishTestItemRQ();
        rq.setEndTime(new Date());
        Optional.ofNullable(status).ifPresent(it -> {
            rq.setStatus(it.name());
            if (StatusEnum.FAILED.equals(it)) {
                rq.setIssue(this.issueType());
            }
        });
        this.finishTestItemHandler.finishTestItem(user, projectDetails, testItemId, rq);
    }

    private boolean hasChildren(TestItemTypeEnum testItemType) {
        return testItemType != TestItemTypeEnum.STEP && testItemType != TestItemTypeEnum.BEFORE_CLASS && testItemType != TestItemTypeEnum.BEFORE_METHOD && testItemType != TestItemTypeEnum.AFTER_CLASS && testItemType != TestItemTypeEnum.AFTER_METHOD;
    }

    private Issue issueType() {
        int ISSUE_PROBABILITY = 25;
        if (ContentUtils.getWithProbability(ISSUE_PROBABILITY)) {
            return ContentUtils.getProductBug();
        }
        if (ContentUtils.getWithProbability(ISSUE_PROBABILITY)) {
            return ContentUtils.getAutomationBug();
        }
        if (ContentUtils.getWithProbability(ISSUE_PROBABILITY)) {
            return ContentUtils.getSystemIssue();
        }
        return ContentUtils.getInvestigate();
    }
}

