/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.ws.controller;

import com.epam.ta.reportportal.commons.EntityUtils;
import com.epam.ta.reportportal.commons.ReportPortalUser;
import com.epam.ta.reportportal.commons.querygen.CompositeFilter;
import com.epam.ta.reportportal.commons.querygen.Filter;
import com.epam.ta.reportportal.commons.querygen.Queryable;
import com.epam.ta.reportportal.core.jasper.GetJasperReportHandler;
import com.epam.ta.reportportal.core.user.CreateUserHandler;
import com.epam.ta.reportportal.core.user.DeleteUserHandler;
import com.epam.ta.reportportal.core.user.EditUserHandler;
import com.epam.ta.reportportal.core.user.GetUserHandler;
import com.epam.ta.reportportal.entity.jasper.ReportFormat;
import com.epam.ta.reportportal.entity.user.User;
import com.epam.ta.reportportal.entity.user.UserRole;
import com.epam.ta.reportportal.exception.ReportPortalException;
import com.epam.ta.reportportal.ws.model.DeleteBulkRQ;
import com.epam.ta.reportportal.ws.model.DeleteBulkRS;
import com.epam.ta.reportportal.ws.model.ErrorType;
import com.epam.ta.reportportal.ws.model.ModelViews;
import com.epam.ta.reportportal.ws.model.OperationCompletionRS;
import com.epam.ta.reportportal.ws.model.YesNoRS;
import com.epam.ta.reportportal.ws.model.user.ChangePasswordRQ;
import com.epam.ta.reportportal.ws.model.user.CreateUserBidRS;
import com.epam.ta.reportportal.ws.model.user.CreateUserRQ;
import com.epam.ta.reportportal.ws.model.user.CreateUserRQConfirm;
import com.epam.ta.reportportal.ws.model.user.CreateUserRQFull;
import com.epam.ta.reportportal.ws.model.user.CreateUserRS;
import com.epam.ta.reportportal.ws.model.user.EditUserRQ;
import com.epam.ta.reportportal.ws.model.user.ResetPasswordRQ;
import com.epam.ta.reportportal.ws.model.user.RestorePasswordRQ;
import com.epam.ta.reportportal.ws.model.user.UserBidRS;
import com.epam.ta.reportportal.ws.model.user.UserResource;
import com.epam.ta.reportportal.ws.resolver.ActiveRole;
import com.epam.ta.reportportal.ws.resolver.FilterFor;
import com.epam.ta.reportportal.ws.resolver.ResponseView;
import com.epam.ta.reportportal.ws.resolver.SortFor;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.jooq.Operator;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.domain.Pageable;
import org.springframework.http.HttpRequest;
import org.springframework.http.HttpStatus;
import org.springframework.http.server.ServletServerHttpRequest;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.core.annotation.AuthenticationPrincipal;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.util.UriComponentsBuilder;

@RestController
@RequestMapping(value={"/v1/user"})
public class UserController {
    private final CreateUserHandler createUserMessageHandler;
    private final EditUserHandler editUserMessageHandler;
    private final DeleteUserHandler deleteUserHandler;
    private final GetUserHandler getUserHandler;
    private final GetJasperReportHandler<User> jasperReportHandler;

    @Autowired
    public UserController(CreateUserHandler createUserMessageHandler, EditUserHandler editUserMessageHandler, DeleteUserHandler deleteUserHandler, GetUserHandler getUserHandler, @Qualifier(value="userJasperReportHandler") GetJasperReportHandler<User> jasperReportHandler) {
        this.createUserMessageHandler = createUserMessageHandler;
        this.editUserMessageHandler = editUserMessageHandler;
        this.deleteUserHandler = deleteUserHandler;
        this.getUserHandler = getUserHandler;
        this.jasperReportHandler = jasperReportHandler;
    }

    @PostMapping
    @ResponseStatus(value=HttpStatus.CREATED)
    @PreAuthorize(value="hasRole('ADMINISTRATOR')")
    @ApiOperation(value="Create specified user", notes="Allowable only for users with administrator role")
    public CreateUserRS createUserByAdmin(@RequestBody @Validated CreateUserRQFull rq, @AuthenticationPrincipal ReportPortalUser currentUser, HttpServletRequest request) {
        String basicURL = UriComponentsBuilder.fromHttpRequest((HttpRequest)new ServletServerHttpRequest(request)).replacePath(null).replaceQuery(null).build().toUriString();
        return this.createUserMessageHandler.createUserByAdmin(rq, currentUser, basicURL);
    }

    @Transactional
    @PostMapping(value={"/bid"})
    @ResponseStatus(value=HttpStatus.CREATED)
    @PreAuthorize(value="(hasPermission(#createUserRQ.getDefaultProject(), 'projectManagerPermission')) || hasRole('ADMINISTRATOR')")
    @ApiOperation(value="Register invitation for user who will be created")
    public CreateUserBidRS createUserBid(@RequestBody @Validated CreateUserRQ createUserRQ, @AuthenticationPrincipal ReportPortalUser currentUser, HttpServletRequest request) {
        URI rqUrl = UriComponentsBuilder.fromHttpRequest((HttpRequest)new ServletServerHttpRequest(request)).replacePath(null).replaceQuery(null).build().toUri();
        return this.createUserMessageHandler.createUserBid(createUserRQ, currentUser, rqUrl.toASCIIString());
    }

    @PostMapping(value={"/registration"})
    @ResponseStatus(value=HttpStatus.CREATED)
    @ApiOperation(value="Activate invitation and create user in system")
    public CreateUserRS createUser(@RequestBody @Validated CreateUserRQConfirm request, @RequestParam(value="uuid") String uuid) {
        return this.createUserMessageHandler.createUser(request, uuid);
    }

    @Transactional(readOnly=true)
    @GetMapping(value={"/registration"})
    public UserBidRS getUserBidInfo(@RequestParam(value="uuid") String uuid) {
        return this.getUserHandler.getBidInformation(uuid);
    }

    @Transactional
    @DeleteMapping(value={"/{id}"})
    @PreAuthorize(value="hasRole('ADMINISTRATOR')")
    @ApiOperation(value="Delete specified user", notes="Allowable only for users with administrator role")
    public OperationCompletionRS deleteUser(@PathVariable(value="id") Long userId, @AuthenticationPrincipal ReportPortalUser currentUser) {
        return this.deleteUserHandler.deleteUser(userId, currentUser);
    }

    @Transactional
    @DeleteMapping
    @PreAuthorize(value="hasRole('ADMINISTRATOR')")
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="Delete specified users by ids")
    public DeleteBulkRS deleteUsers(@RequestBody @Valid DeleteBulkRQ deleteBulkRQ, @AuthenticationPrincipal ReportPortalUser user) {
        return this.deleteUserHandler.deleteUsers(deleteBulkRQ, user);
    }

    @Transactional
    @PutMapping(value={"/{login}"})
    @PreAuthorize(value="(#login.toLowerCase() == authentication.name) || hasRole('ADMINISTRATOR')")
    @ApiOperation(value="Edit specified user", notes="Only for administrators and profile's owner")
    public OperationCompletionRS editUser(@PathVariable String login, @RequestBody @Validated EditUserRQ editUserRQ, @ActiveRole UserRole role, @AuthenticationPrincipal ReportPortalUser currentUser) {
        return this.editUserMessageHandler.editUser(EntityUtils.normalizeId((String)login), editUserRQ, currentUser);
    }

    @Transactional(readOnly=true)
    @GetMapping(value={"/{login}"})
    @ResponseView(value=ModelViews.FullUserView.class)
    @PreAuthorize(value="(#login.toLowerCase() == authentication.name) || hasRole('ADMINISTRATOR')")
    @ApiOperation(value="Return information about specified user", notes="Only for administrators and profile's owner")
    public UserResource getUser(@PathVariable String login, @AuthenticationPrincipal ReportPortalUser currentUser) {
        return this.getUserHandler.getUser(EntityUtils.normalizeId((String)login), currentUser);
    }

    @Transactional
    @GetMapping(value={"", "/"})
    @ApiOperation(value="Return information about current logged-in user")
    public UserResource getMyself(@AuthenticationPrincipal ReportPortalUser currentUser) {
        return this.getUserHandler.getUser(currentUser);
    }

    @Transactional(readOnly=true)
    @GetMapping(value={"/all"})
    @ResponseView(value=ModelViews.FullUserView.class)
    @PreAuthorize(value="hasRole('ADMINISTRATOR')")
    @ApiOperation(value="Return information about all users", notes="Allowable only for users with administrator role")
    public Iterable<UserResource> getUsers(@FilterFor(value=User.class) Filter filter, @SortFor(value=User.class) Pageable pageable, @FilterFor(value=User.class) Queryable queryable, @AuthenticationPrincipal ReportPortalUser currentUser) {
        return this.getUserHandler.getAllUsers((Queryable)new CompositeFilter(Operator.AND, new Queryable[]{filter, queryable}), pageable);
    }

    @Transactional(readOnly=true)
    @GetMapping(value={"/registration/info"})
    public YesNoRS validateInfo(@RequestParam(value="username", required=false) String username, @RequestParam(value="email", required=false) String email) {
        return this.getUserHandler.validateInfo(username, email);
    }

    @Transactional
    @PostMapping(value={"/password/restore"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="Create a restore password request")
    public OperationCompletionRS restorePassword(@RequestBody @Validated RestorePasswordRQ rq, HttpServletRequest request) {
        String baseUrl = UriComponentsBuilder.fromHttpRequest((HttpRequest)new ServletServerHttpRequest(request)).replacePath(null).replaceQuery(null).build().toUriString();
        return this.createUserMessageHandler.createRestorePasswordBid(rq, baseUrl);
    }

    @Transactional
    @PostMapping(value={"/password/reset"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="Reset password")
    public OperationCompletionRS resetPassword(@RequestBody @Validated ResetPasswordRQ rq) {
        return this.createUserMessageHandler.resetPassword(rq);
    }

    @Transactional(readOnly=true)
    @GetMapping(value={"/password/reset/{uuid}"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="Check if a restore password bid exists")
    public YesNoRS isRestorePasswordBidExist(@PathVariable String uuid) {
        return this.createUserMessageHandler.isResetPasswordBidExist(uuid);
    }

    @Transactional
    @PostMapping(value={"/password/change"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="Change own password")
    public OperationCompletionRS changePassword(@RequestBody @Validated ChangePasswordRQ changePasswordRQ, @AuthenticationPrincipal ReportPortalUser currentUser) {
        return this.editUserMessageHandler.changePassword(currentUser, changePasswordRQ);
    }

    @Transactional(readOnly=true)
    @GetMapping(value={"/{userName}/projects"})
    @ResponseStatus(value=HttpStatus.OK)
    public Map<String, UserResource.AssignedProject> getUserProjects(@PathVariable String userName, @AuthenticationPrincipal ReportPortalUser currentUser) {
        return this.getUserHandler.getUserProjects(userName);
    }

    @Transactional(readOnly=true)
    @GetMapping(value={"/search"})
    @ResponseStatus(value=HttpStatus.OK)
    @PreAuthorize(value="hasRole('ADMINISTRATOR')")
    public Iterable<UserResource> findUsers(@RequestParam(value="term") String term, Pageable pageable, @AuthenticationPrincipal ReportPortalUser user) {
        return this.getUserHandler.searchUsers(term, pageable);
    }

    @Transactional(readOnly=true)
    @GetMapping(value={"/export"})
    @PreAuthorize(value="hasRole('ADMINISTRATOR')")
    @ApiOperation(value="Exports information about all users", notes="Allowable only for users with administrator role")
    public void export(@ApiParam(allowableValues="csv") @RequestParam(value="view", required=false, defaultValue="csv") String view, @FilterFor(value=User.class) Filter filter, @FilterFor(value=User.class) Queryable queryable, @AuthenticationPrincipal ReportPortalUser currentUser, HttpServletResponse response) {
        ReportFormat format = this.jasperReportHandler.getReportFormat(view);
        response.setContentType(format.getContentType());
        response.setHeader("Content-Disposition", String.format("attachment; filename=RP_USERS_%s_Report.%s", format.name(), format.getValue()));
        try (ServletOutputStream outputStream = response.getOutputStream();){
            this.getUserHandler.exportUsers(format, (OutputStream)outputStream, (Queryable)new CompositeFilter(Operator.AND, new Queryable[]{filter, queryable}));
        }
        catch (IOException e) {
            throw new ReportPortalException(ErrorType.BAD_REQUEST_ERROR, new Object[]{"Unable to write data to the response."});
        }
    }
}

