/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.ws.controller;

import com.epam.ta.reportportal.commons.ReportPortalUser;
import com.epam.ta.reportportal.commons.querygen.Filter;
import com.epam.ta.reportportal.core.filter.DeleteUserFilterHandler;
import com.epam.ta.reportportal.core.filter.GetUserFilterHandler;
import com.epam.ta.reportportal.core.filter.UpdateUserFilterHandler;
import com.epam.ta.reportportal.core.shareable.GetShareableEntityHandler;
import com.epam.ta.reportportal.entity.filter.UserFilter;
import com.epam.ta.reportportal.util.ProjectExtractor;
import com.epam.ta.reportportal.ws.converter.converters.UserFilterConverter;
import com.epam.ta.reportportal.ws.model.CollectionsRQ;
import com.epam.ta.reportportal.ws.model.EntryCreatedRS;
import com.epam.ta.reportportal.ws.model.OperationCompletionRS;
import com.epam.ta.reportportal.ws.model.SharedEntity;
import com.epam.ta.reportportal.ws.model.filter.BulkUpdateFilterRQ;
import com.epam.ta.reportportal.ws.model.filter.UpdateUserFilterRQ;
import com.epam.ta.reportportal.ws.model.filter.UserFilterResource;
import com.epam.ta.reportportal.ws.resolver.FilterFor;
import com.epam.ta.reportportal.ws.resolver.SortFor;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.http.HttpStatus;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.core.annotation.AuthenticationPrincipal;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RestController
@PreAuthorize(value="hasPermission(#projectName.toLowerCase(), 'isAssignedToProject')")
@RequestMapping(value={"/v1/{projectName}/filter"})
public class UserFilterController {
    private final GetUserFilterHandler getFilterHandler;
    private final GetShareableEntityHandler<UserFilter> getShareableEntityHandler;
    private final DeleteUserFilterHandler deleteFilterHandler;
    private final UpdateUserFilterHandler updateUserFilterHandler;

    @Autowired
    public UserFilterController(GetUserFilterHandler getFilterHandler, GetShareableEntityHandler<UserFilter> getShareableEntityHandler, DeleteUserFilterHandler deleteFilterHandler, UpdateUserFilterHandler updateUserFilterHandler) {
        this.getFilterHandler = getFilterHandler;
        this.getShareableEntityHandler = getShareableEntityHandler;
        this.deleteFilterHandler = deleteFilterHandler;
        this.updateUserFilterHandler = updateUserFilterHandler;
    }

    @Transactional
    @PostMapping
    @ResponseStatus(value=HttpStatus.CREATED)
    @ApiOperation(value="Create user filter")
    public EntryCreatedRS createFilter(@PathVariable String projectName, @RequestBody @Validated UpdateUserFilterRQ createFilterRQ, @AuthenticationPrincipal ReportPortalUser user) {
        return this.updateUserFilterHandler.createFilter(createFilterRQ, projectName, user);
    }

    @Transactional(readOnly=true)
    @GetMapping(value={"/{filterId}"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="Get specified user filter by id")
    public UserFilterResource getFilter(@PathVariable String projectName, @PathVariable Long filterId, @AuthenticationPrincipal ReportPortalUser user) {
        UserFilter filter = this.getShareableEntityHandler.getPermitted(filterId, ProjectExtractor.extractProjectDetails(user, projectName));
        return UserFilterConverter.TO_FILTER_RESOURCE.apply(filter);
    }

    @Transactional(readOnly=true)
    @GetMapping
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="Get permitted (own and shared) filters")
    public Iterable<UserFilterResource> getAllFilters(@PathVariable String projectName, @SortFor(value=UserFilter.class) Pageable pageable, @FilterFor(value=UserFilter.class) Filter filter, @AuthenticationPrincipal ReportPortalUser user) {
        return this.getFilterHandler.getPermitted(projectName, pageable, filter, user);
    }

    @Transactional(readOnly=true)
    @GetMapping(value={"/own"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="Get all filters for specified user who own them")
    public Iterable<UserFilterResource> getOwnFilters(@PathVariable String projectName, @SortFor(value=UserFilter.class) Pageable pageable, @FilterFor(value=UserFilter.class) Filter filter, @AuthenticationPrincipal ReportPortalUser user) {
        return this.getFilterHandler.getOwn(projectName, pageable, filter, user);
    }

    @Transactional(readOnly=true)
    @GetMapping(value={"/shared"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="Get all available shared filters (except own shared filters)")
    public Iterable<UserFilterResource> getSharedFilters(@PathVariable String projectName, @SortFor(value=UserFilter.class) Pageable pageable, @FilterFor(value=UserFilter.class) Filter filter, @AuthenticationPrincipal ReportPortalUser user) {
        return this.getFilterHandler.getShared(projectName, pageable, filter, user);
    }

    @Transactional
    @DeleteMapping(value={"/{filterId}"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="Delete specified user filter by id")
    public OperationCompletionRS deleteFilter(@PathVariable String projectName, @PathVariable Long filterId, @AuthenticationPrincipal ReportPortalUser user) {
        return this.deleteFilterHandler.deleteFilter(filterId, ProjectExtractor.extractProjectDetails(user, projectName), user);
    }

    @Transactional(readOnly=true)
    @GetMapping(value={"/names"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="Get available filter names")
    public Iterable<SharedEntity> getAllFiltersNames(@PathVariable String projectName, @SortFor(value=UserFilter.class) Pageable pageable, @FilterFor(value=UserFilter.class) Filter filter, @AuthenticationPrincipal ReportPortalUser user, @RequestParam(value="share", defaultValue="false", required=false) boolean isShared) {
        return this.getFilterHandler.getFiltersNames(ProjectExtractor.extractProjectDetails(user, projectName), pageable, filter, user, isShared);
    }

    @Transactional
    @PutMapping(value={"/{filterId}"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="Update specified user filter")
    public OperationCompletionRS updateUserFilter(@PathVariable String projectName, @PathVariable Long filterId, @RequestBody @Validated UpdateUserFilterRQ updateRQ, @AuthenticationPrincipal ReportPortalUser user) {
        return this.updateUserFilterHandler.updateUserFilter(filterId, updateRQ, ProjectExtractor.extractProjectDetails(user, projectName), user);
    }

    @Transactional(readOnly=true)
    @GetMapping(value={"/filters"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="Get list of specified user filters")
    public List<UserFilterResource> getUserFilters(@PathVariable String projectName, @RequestParam(value="ids") Long[] ids, @AuthenticationPrincipal ReportPortalUser user) {
        List<UserFilter> filters = this.getFilterHandler.getFiltersById(ids, ProjectExtractor.extractProjectDetails(user, projectName), user);
        return filters.stream().map(UserFilterConverter.TO_FILTER_RESOURCE).collect(Collectors.toList());
    }

    @Transactional
    @RequestMapping(method={RequestMethod.PUT})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="Update list of user filters")
    public List<OperationCompletionRS> updateUserFilters(@PathVariable String projectName, @RequestBody @Validated CollectionsRQ<BulkUpdateFilterRQ> updateRQ, @AuthenticationPrincipal ReportPortalUser user) {
        return this.updateUserFilterHandler.updateUserFilter(updateRQ, ProjectExtractor.extractProjectDetails(user, projectName), user);
    }
}

