/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.ws.converter.builders;

import com.epam.ta.reportportal.entity.activity.Activity;
import com.epam.ta.reportportal.entity.activity.ActivityAction;
import com.epam.ta.reportportal.entity.activity.ActivityDetails;
import com.epam.ta.reportportal.entity.activity.HistoryField;
import java.time.LocalDateTime;
import java.util.Optional;
import java.util.function.Supplier;

public class ActivityBuilder
implements Supplier<Activity> {
    private Activity activity = new Activity();
    private ActivityDetails details = new ActivityDetails();

    public ActivityBuilder addUserId(Long userId) {
        this.activity.setUserId(userId);
        return this;
    }

    public ActivityBuilder addUserName(String postedName) {
        this.activity.setUsername(postedName);
        return this;
    }

    public ActivityBuilder addProjectId(Long projectId) {
        this.activity.setProjectId(projectId);
        return this;
    }

    public ActivityBuilder addActivityEntityType(Activity.ActivityEntityType activityEntityType) {
        this.activity.setActivityEntityType(activityEntityType.getValue());
        return this;
    }

    public ActivityBuilder addAction(ActivityAction action) {
        this.activity.setAction(action.getValue());
        return this;
    }

    public ActivityBuilder addDetails(ActivityDetails details) {
        this.details = details;
        return this;
    }

    public ActivityBuilder addObjectName(String name) {
        this.details.setObjectName(name);
        return this;
    }

    public ActivityBuilder addHistoryField(String field, String before, String after) {
        this.details.addHistoryField(HistoryField.of((String)field, (String)before, (String)after));
        return this;
    }

    public ActivityBuilder addHistoryField(Optional<HistoryField> historyField) {
        historyField.ifPresent(it -> this.details.addHistoryField(it));
        return this;
    }

    public ActivityBuilder addCreatedAt(LocalDateTime localDateTime) {
        this.activity.setCreatedAt(localDateTime);
        return this;
    }

    public ActivityBuilder addCreatedNow() {
        this.activity.setCreatedAt(LocalDateTime.now());
        return this;
    }

    public ActivityBuilder addObjectId(Long objectId) {
        this.activity.setObjectId(objectId);
        return this;
    }

    @Override
    public Activity get() {
        this.activity.setDetails(this.details);
        return this.activity;
    }
}

