/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.ws.converter.converters;

import com.epam.ta.reportportal.commons.EntityUtils;
import com.epam.ta.reportportal.core.analyzer.auto.impl.AnalyzerStatusCache;
import com.epam.ta.reportportal.dao.UserRepository;
import com.epam.ta.reportportal.entity.launch.Launch;
import com.epam.ta.reportportal.ws.converter.converters.StatisticsConverter;
import com.epam.ta.reportportal.ws.model.activity.LaunchActivityResource;
import com.epam.ta.reportportal.ws.model.attribute.ItemAttributeResource;
import com.epam.ta.reportportal.ws.model.launch.LaunchResource;
import com.epam.ta.reportportal.ws.model.launch.Mode;
import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.Date;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class LaunchConverter {
    @Autowired
    private AnalyzerStatusCache analyzerStatusCache;
    @Autowired
    private UserRepository userRepository;
    public static final Function<Launch, LaunchActivityResource> TO_ACTIVITY_RESOURCE = launch -> {
        LaunchActivityResource resource = new LaunchActivityResource();
        resource.setId(launch.getId());
        resource.setProjectId(launch.getProjectId());
        resource.setName(launch.getName() + " #" + launch.getNumber());
        return resource;
    };
    public Function<Launch, LaunchResource> TO_RESOURCE = db -> {
        Preconditions.checkNotNull((Object)db);
        LaunchResource resource = new LaunchResource();
        resource.setLaunchId(db.getId());
        resource.setUuid(db.getUuid());
        resource.setName(db.getName());
        resource.setNumber(db.getNumber());
        resource.setDescription(db.getDescription());
        resource.setStatus(db.getStatus() == null ? null : db.getStatus().toString());
        resource.setStartTime(db.getStartTime() == null ? null : (Date)EntityUtils.TO_DATE.apply(db.getStartTime()));
        resource.setEndTime(db.getEndTime() == null ? null : (Date)EntityUtils.TO_DATE.apply(db.getEndTime()));
        Optional.ofNullable(db.getLastModified()).map(EntityUtils.TO_DATE).ifPresent(arg_0 -> ((LaunchResource)resource).setLastModified(arg_0));
        resource.setAttributes(LaunchConverter.getAttributes(db));
        resource.setMode(db.getMode() == null ? null : Mode.valueOf((String)db.getMode().name()));
        resource.setAnalyzers(this.analyzerStatusCache.getStartedAnalyzers(db.getId()));
        resource.setStatisticsResource(StatisticsConverter.TO_RESOURCE.apply(db.getStatistics()));
        resource.setApproximateDuration(db.getApproximateDuration());
        resource.setHasRetries(db.isHasRetries());
        Optional.ofNullable(db.getUserId()).flatMap(id -> this.userRepository.findLoginById(id)).ifPresent(arg_0 -> ((LaunchResource)resource).setOwner(arg_0));
        resource.setRerun(db.isRerun());
        return resource;
    };

    private static Set<ItemAttributeResource> getAttributes(Launch launch) {
        return Optional.ofNullable(launch.getAttributes()).map(tags -> tags.stream().filter(it -> it.isSystem() == false).map(it -> new ItemAttributeResource(it.getKey(), it.getValue())).collect(Collectors.toSet())).orElse(Collections.emptySet());
    }
}

