/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.ws.converter.converters;

import com.epam.ta.reportportal.commons.EntityUtils;
import com.epam.ta.reportportal.entity.item.issue.IssueType;
import com.epam.ta.reportportal.entity.project.Project;
import com.epam.ta.reportportal.entity.project.ProjectInfo;
import com.epam.ta.reportportal.entity.project.ProjectIssueType;
import com.epam.ta.reportportal.ws.model.project.ProjectInfoResource;
import com.epam.ta.reportportal.ws.model.project.config.IssueSubTypeResource;
import com.epam.ta.reportportal.ws.model.project.config.ProjectSettingsResource;
import com.google.common.base.Preconditions;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;

public final class ProjectSettingsConverter {
    public static final Function<ProjectInfo, ProjectInfoResource> TO_PROJECT_INFO_RESOURCE = project -> {
        Preconditions.checkNotNull((Object)project);
        ProjectInfoResource resource = new ProjectInfoResource();
        resource.setUsersQuantity(Integer.valueOf(project.getUsersQuantity()));
        resource.setLaunchesQuantity(Integer.valueOf(project.getLaunchesQuantity()));
        resource.setProjectId(project.getId());
        resource.setProjectName(project.getName());
        resource.setCreationDate((Date)EntityUtils.TO_DATE.apply(project.getCreationDate()));
        resource.setLastRun((Date)Optional.ofNullable(project.getLastRun()).map(EntityUtils.TO_DATE).orElse(null));
        resource.setEntryType(project.getProjectType());
        resource.setOrganization(project.getOrganization());
        return resource;
    };
    public static final Function<IssueType, IssueSubTypeResource> TO_SUBTYPE_RESOURCE = issueType -> {
        IssueSubTypeResource issueSubTypeResource = new IssueSubTypeResource();
        issueSubTypeResource.setId(issueType.getId());
        issueSubTypeResource.setLocator(issueType.getLocator());
        issueSubTypeResource.setColor(issueType.getHexColor());
        issueSubTypeResource.setLongName(issueType.getLongName());
        issueSubTypeResource.setShortName(issueType.getShortName());
        issueSubTypeResource.setTypeRef(issueType.getIssueGroup().getTestItemIssueGroup().getValue());
        return issueSubTypeResource;
    };
    public static final Function<List<IssueType>, Map<String, List<IssueSubTypeResource>>> TO_PROJECT_SUB_TYPES_RESOURCE = issueTypes -> issueTypes.stream().collect(Collectors.groupingBy(it -> it.getIssueGroup().getTestItemIssueGroup().getValue(), Collectors.mapping(TO_SUBTYPE_RESOURCE, Collectors.toList())));
    public static final Function<Project, ProjectSettingsResource> TO_PROJECT_SETTINGS_RESOURCE = project -> {
        ProjectSettingsResource resource = new ProjectSettingsResource();
        resource.setProjectId(project.getId());
        resource.setSubTypes(TO_PROJECT_SUB_TYPES_RESOURCE.apply(project.getProjectIssueTypes().stream().map(ProjectIssueType::getIssueType).collect(Collectors.toList())));
        return resource;
    };

    private ProjectSettingsConverter() {
    }
}

