/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.ws.converter.converters;

import com.epam.ta.reportportal.commons.MoreCollectors;
import com.epam.ta.reportportal.entity.user.User;
import com.epam.ta.reportportal.entity.user.UserType;
import com.epam.ta.reportportal.ws.model.activity.UserActivityResource;
import com.epam.ta.reportportal.ws.model.user.UserResource;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;

public final class UserConverter {
    public static final Function<User, UserResource> TO_RESOURCE = user -> {
        UserResource resource = new UserResource();
        resource.setId(user.getId());
        resource.setUserId(user.getLogin());
        resource.setEmail(user.getEmail());
        resource.setPhotoId(user.getAttachment());
        resource.setFullName(user.getFullName());
        resource.setAccountType(user.getUserType().toString());
        resource.setUserRole(user.getRole().toString());
        resource.setIsLoaded(UserType.UPSA != user.getUserType());
        resource.setMetadata((Object)user.getMetadata().getMetadata());
        if (null != user.getProjects()) {
            ArrayList projects = Lists.newArrayList((Iterable)user.getProjects());
            projects.sort(Comparator.comparing(compare -> compare.getProject().getName()));
            Map userProjects = (Map)user.getProjects().stream().collect(MoreCollectors.toLinkedMap(p -> p.getProject().getName(), p -> {
                UserResource.AssignedProject assignedProject = new UserResource.AssignedProject();
                assignedProject.setEntryType(p.getProject().getProjectType().name());
                assignedProject.setProjectRole(p.getProjectRole().toString());
                return assignedProject;
            }));
            resource.setAssignedProjects(userProjects);
        }
        return resource;
    };
    public static final BiFunction<User, Long, UserActivityResource> TO_ACTIVITY_RESOURCE = (user, projectId) -> {
        UserActivityResource resource = new UserActivityResource();
        resource.setId(user.getId());
        resource.setDefaultProjectId(projectId);
        resource.setFullName(user.getFullName());
        return resource;
    };

    private UserConverter() {
    }
}

