/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.auth.permissions;

import com.epam.ta.reportportal.auth.permissions.LookupPermission;
import com.epam.ta.reportportal.auth.permissions.Permission;
import com.epam.ta.reportportal.auth.permissions.ProjectAuthority;
import com.epam.ta.reportportal.commons.ReportPortalUser;
import com.epam.ta.reportportal.commons.validation.BusinessRule;
import com.epam.ta.reportportal.dao.ProjectRepository;
import com.epam.ta.reportportal.ws.model.ErrorType;
import java.util.Collection;
import java.util.Objects;
import javax.inject.Provider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.oauth2.provider.OAuth2Authentication;
import org.springframework.stereotype.Component;

@Component(value="assignedToProjectPermission")
@LookupPermission(value={"isAssignedToProject"})
class AssignedToProjectPermission
implements Permission {
    @Autowired
    private Provider<ProjectRepository> projectRepository;

    AssignedToProjectPermission() {
    }

    @Override
    public boolean isAllowed(Authentication authentication, Object targetDomainObject) {
        if (!authentication.isAuthenticated()) {
            return false;
        }
        OAuth2Authentication oauth = (OAuth2Authentication)authentication;
        ReportPortalUser rpUser = (ReportPortalUser)oauth.getUserAuthentication().getPrincipal();
        BusinessRule.expect((Object)rpUser, Objects::nonNull).verify(ErrorType.ACCESS_DENIED, new Object[0]);
        ReportPortalUser.ProjectDetails projectDetails = (ReportPortalUser.ProjectDetails)rpUser.getProjectDetails().get(targetDomainObject.toString());
        return projectDetails != null;
    }

    private boolean hasProjectAuthority(Collection<? extends GrantedAuthority> authorityList, String project) {
        return authorityList.stream().filter(a -> a instanceof ProjectAuthority).anyMatch(pa -> ((ProjectAuthority)pa).getProject().equals(project));
    }
}

