/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.analyzer.auto.impl;

import com.epam.ta.reportportal.commons.Preconditions;
import com.epam.ta.reportportal.commons.Predicates;
import com.epam.ta.reportportal.commons.ReportPortalUser;
import com.epam.ta.reportportal.commons.validation.BusinessRule;
import com.epam.ta.reportportal.core.analyzer.auto.SearchLogService;
import com.epam.ta.reportportal.core.analyzer.auto.client.AnalyzerServiceClient;
import com.epam.ta.reportportal.core.analyzer.auto.impl.AnalyzerUtils;
import com.epam.ta.reportportal.core.analyzer.auto.strategy.search.SearchCollectorFactory;
import com.epam.ta.reportportal.core.analyzer.auto.strategy.search.SearchLogsMode;
import com.epam.ta.reportportal.dao.LaunchRepository;
import com.epam.ta.reportportal.dao.LogRepository;
import com.epam.ta.reportportal.dao.ProjectRepository;
import com.epam.ta.reportportal.dao.TestItemRepository;
import com.epam.ta.reportportal.entity.enums.StatusEnum;
import com.epam.ta.reportportal.entity.item.TestItem;
import com.epam.ta.reportportal.entity.launch.Launch;
import com.epam.ta.reportportal.entity.log.Log;
import com.epam.ta.reportportal.entity.project.Project;
import com.epam.ta.reportportal.exception.ReportPortalException;
import com.epam.ta.reportportal.ws.converter.converters.IssueConverter;
import com.epam.ta.reportportal.ws.converter.converters.LogConverter;
import com.epam.ta.reportportal.ws.model.ErrorType;
import com.epam.ta.reportportal.ws.model.analyzer.SearchRq;
import com.epam.ta.reportportal.ws.model.log.SearchLogRq;
import com.epam.ta.reportportal.ws.model.log.SearchLogRs;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class SearchLogServiceImpl
implements SearchLogService {
    private final ProjectRepository projectRepository;
    private final LaunchRepository launchRepository;
    private final TestItemRepository testItemRepository;
    private final LogRepository logRepository;
    private final AnalyzerServiceClient analyzerServiceClient;
    private final SearchCollectorFactory searchCollectorFactory;

    @Autowired
    public SearchLogServiceImpl(ProjectRepository projectRepository, LaunchRepository launchRepository, TestItemRepository testItemRepository, LogRepository logRepository, AnalyzerServiceClient analyzerServiceClient, SearchCollectorFactory searchCollectorFactory) {
        this.projectRepository = projectRepository;
        this.launchRepository = launchRepository;
        this.testItemRepository = testItemRepository;
        this.logRepository = logRepository;
        this.analyzerServiceClient = analyzerServiceClient;
        this.searchCollectorFactory = searchCollectorFactory;
    }

    @Override
    public Iterable<SearchLogRs> search(Long itemId, SearchLogRq request, ReportPortalUser.ProjectDetails projectDetails) {
        Project project = (Project)this.projectRepository.findById((Object)projectDetails.getProjectId()).orElseThrow(() -> new ReportPortalException(ErrorType.PROJECT_NOT_FOUND, new Object[]{projectDetails.getProjectId()}));
        TestItem item = (TestItem)this.testItemRepository.findById((Object)itemId).orElseThrow(() -> new ReportPortalException(ErrorType.TEST_ITEM_NOT_FOUND, new Object[]{itemId}));
        Launch launch = (Launch)this.launchRepository.findById((Object)item.getLaunchId()).orElseThrow(() -> new ReportPortalException(ErrorType.LAUNCH_NOT_FOUND, new Object[]{item.getLaunchId()}));
        BusinessRule.expect((Object)item.getItemResults().getStatus(), (Predicate)Predicates.not((Predicate)Preconditions.statusIn((StatusEnum[])new StatusEnum[]{StatusEnum.IN_PROGRESS}))).verify(ErrorType.TEST_ITEM_IS_NOT_FINISHED, new Object[0]);
        return this.composeRequest(request, project, item, launch).map(this::processRequest).orElse(Collections.emptyList());
    }

    private Optional<SearchRq> composeRequest(SearchLogRq request, Project project, TestItem item, Launch launch) {
        SearchLogsMode searchMode = SearchLogsMode.fromString(request.getSearchMode()).orElseThrow(() -> new ReportPortalException(ErrorType.BAD_REQUEST_ERROR, new Object[]{request.getSearchMode()}));
        SearchRq searchRq = new SearchRq();
        searchRq.setFilteredLaunchIds(this.searchCollectorFactory.getCollector(searchMode).collect(request.getFilterId(), launch));
        List logMessages = this.logRepository.findMessagesByItemIdAndLevelGte(item.getItemId(), Integer.valueOf(40000));
        if (CollectionUtils.isEmpty((Collection)logMessages)) {
            return Optional.empty();
        }
        searchRq.setLogMessages(logMessages);
        searchRq.setLogLines(AnalyzerUtils.getAnalyzerConfig(project).getNumberOfLogLines());
        searchRq.setItemId(item.getItemId());
        searchRq.setLaunchId(launch.getId());
        searchRq.setLaunchName(launch.getName());
        searchRq.setProjectId(project.getId());
        return Optional.of(searchRq);
    }

    private Collection<SearchLogRs> processRequest(SearchRq request) {
        List foundLogs = this.logRepository.findAllById(this.analyzerServiceClient.searchLogs(request));
        HashMap foundLogsMap = Maps.newHashMap();
        foundLogs.forEach(log -> {
            foundLogsMap.computeIfPresent(log.getTestItem().getItemId(), (key, value) -> {
                value.getLogs().add(LogConverter.TO_LOG_ENTRY.apply((Log)log));
                return value;
            });
            Long launchId = Optional.ofNullable(log.getTestItem().getLaunchId()).orElseThrow(() -> new ReportPortalException(ErrorType.LAUNCH_NOT_FOUND, new Object[0]));
            Launch launch = (Launch)this.launchRepository.findById((Object)launchId).orElseThrow(() -> new ReportPortalException(ErrorType.LAUNCH_NOT_FOUND, new Object[]{launchId}));
            Map pathNames = this.testItemRepository.selectPathNames(log.getTestItem().getPath());
            foundLogsMap.putIfAbsent(log.getTestItem().getItemId(), this.composeResponse(launch, (Log)log, pathNames));
        });
        return foundLogsMap.values();
    }

    private SearchLogRs composeResponse(Launch launch, Log log, Map<Long, String> pathNames) {
        SearchLogRs response = new SearchLogRs();
        response.setLaunchId(launch.getId());
        response.setLaunchName(launch.getName() + " #" + launch.getNumber());
        response.setItemId(log.getTestItem().getItemId());
        response.setItemName(log.getTestItem().getName());
        response.setPath(log.getTestItem().getPath());
        response.setPathNames(pathNames);
        response.setPatternTemplates(log.getTestItem().getPatternTemplateTestItems().stream().map(patternTemplateTestItem -> patternTemplateTestItem.getPatternTemplate().getName()).collect(Collectors.toSet()));
        response.setDuration(log.getTestItem().getItemResults().getDuration().doubleValue());
        response.setStatus(log.getTestItem().getItemResults().getStatus().name());
        TestItem itemWithStats = log.getTestItem();
        while (!itemWithStats.isHasStats()) {
            itemWithStats = itemWithStats.getParent();
        }
        response.setIssue(IssueConverter.TO_MODEL.apply(itemWithStats.getItemResults().getIssue()));
        response.setLogs((List)Lists.newArrayList((Object[])new SearchLogRs.LogEntry[]{LogConverter.TO_LOG_ENTRY.apply(log)}));
        return response;
    }
}

