/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.analyzer.auto.indexer;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.concurrent.TimeUnit;
import org.springframework.stereotype.Service;

@Service
public class IndexerStatusCache {
    private static final int CACHE_ITEM_LIVE = 10;
    private static final int MAXIMUM_SIZE = 50000;
    private Cache<Long, Boolean> indexingStatus = CacheBuilder.newBuilder().maximumSize(50000L).expireAfterWrite(10L, TimeUnit.MINUTES).build();

    public void indexingStarted(Long projectId) {
        this.indexingStatus.put((Object)projectId, (Object)true);
    }

    public void indexingFinished(Long projectId) {
        this.indexingStatus.invalidate((Object)projectId);
    }

    public Cache<Long, Boolean> getIndexingStatus() {
        return this.indexingStatus;
    }
}

