/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.dashboard.impl;

import com.epam.ta.reportportal.commons.ReportPortalUser;
import com.epam.ta.reportportal.commons.querygen.Filter;
import com.epam.ta.reportportal.commons.querygen.ProjectFilter;
import com.epam.ta.reportportal.commons.querygen.Queryable;
import com.epam.ta.reportportal.core.dashboard.GetDashboardHandler;
import com.epam.ta.reportportal.dao.DashboardRepository;
import com.epam.ta.reportportal.entity.dashboard.Dashboard;
import com.epam.ta.reportportal.ws.converter.PagedResourcesAssembler;
import com.epam.ta.reportportal.ws.converter.converters.DashboardConverter;
import com.epam.ta.reportportal.ws.model.SharedEntity;
import com.epam.ta.reportportal.ws.model.dashboard.DashboardResource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

@Service
public class GetDashboardHandlerImpl
implements GetDashboardHandler {
    private DashboardRepository dashboardRepository;

    @Autowired
    public void setDashboardRepository(DashboardRepository dashboardRepository) {
        this.dashboardRepository = dashboardRepository;
    }

    @Override
    public Iterable<DashboardResource> getPermitted(ReportPortalUser.ProjectDetails projectDetails, Pageable pageable, Filter filter, ReportPortalUser user) {
        Page permitted = this.dashboardRepository.getPermitted(ProjectFilter.of((Queryable)filter, (Long)projectDetails.getProjectId()), pageable, user.getUsername());
        return (Iterable)PagedResourcesAssembler.pageConverter(DashboardConverter.TO_RESOURCE).apply((Page<Dashboard>)permitted);
    }

    @Override
    public Iterable<SharedEntity> getSharedDashboardsNames(ReportPortalUser.ProjectDetails projectDetails, Pageable pageable, Filter filter, ReportPortalUser user) {
        Page shared = this.dashboardRepository.getShared(ProjectFilter.of((Queryable)filter, (Long)projectDetails.getProjectId()), pageable, user.getUsername());
        return (Iterable)PagedResourcesAssembler.pageConverter(DashboardConverter.TO_SHARED_ENTITY).apply((Page<Dashboard>)shared);
    }
}

