/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.events.handler;

import com.epam.ta.reportportal.binary.UserBinaryDataService;
import com.epam.ta.reportportal.core.events.activity.UserCreatedEvent;
import com.epam.ta.reportportal.dao.UserRepository;
import com.epam.ta.reportportal.entity.user.User;
import com.epam.ta.reportportal.util.MultipartFileUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Profile;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;

@Profile(value={"!unittest"})
@Component
@Transactional
public class AttachDefaultPhotoEventHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(UserCreatedEvent.class);
    private final UserRepository userRepository;
    private final UserBinaryDataService userBinaryDataService;

    @Autowired
    public AttachDefaultPhotoEventHandler(UserRepository userRepository, UserBinaryDataService userBinaryDataService) {
        this.userRepository = userRepository;
        this.userBinaryDataService = userBinaryDataService;
    }

    @EventListener
    public void handleContextRefresh(ContextRefreshedEvent event) {
        this.userRepository.findByLogin("superadmin").ifPresent(it -> this.attachPhoto((User)it, "image/superAdminPhoto.jpg"));
        this.userRepository.findByLogin("default").ifPresent(it -> this.attachPhoto((User)it, "image/defaultUserPhoto.jpg"));
    }

    private void attachPhoto(User user, String photoPath) {
        if (StringUtils.isEmpty((CharSequence)user.getAttachment())) {
            try {
                this.userBinaryDataService.saveUserPhoto(user, (MultipartFile)MultipartFileUtils.getMultipartFile(photoPath));
            }
            catch (Exception exception) {
                LOGGER.error("Cannot attach default photo to user '{}'. Error: {}", (Object)user.getLogin(), (Object)exception);
            }
        }
    }
}

