/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.filter.impl;

import com.epam.ta.reportportal.auth.acl.ShareableObjectsHandler;
import com.epam.ta.reportportal.commons.ReportPortalUser;
import com.epam.ta.reportportal.commons.validation.BusinessRule;
import com.epam.ta.reportportal.core.events.MessageBus;
import com.epam.ta.reportportal.core.events.activity.FilterDeletedEvent;
import com.epam.ta.reportportal.core.filter.DeleteUserFilterHandler;
import com.epam.ta.reportportal.core.filter.GetUserFilterHandler;
import com.epam.ta.reportportal.core.shareable.GetShareableEntityHandler;
import com.epam.ta.reportportal.dao.UserFilterRepository;
import com.epam.ta.reportportal.entity.filter.UserFilter;
import com.epam.ta.reportportal.ws.converter.converters.UserFilterConverter;
import com.epam.ta.reportportal.ws.model.ErrorType;
import com.epam.ta.reportportal.ws.model.OperationCompletionRS;
import java.util.function.Predicate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DeleteUserFilterHandlerImpl
implements DeleteUserFilterHandler {
    private final UserFilterRepository userFilterRepository;
    private final GetShareableEntityHandler<UserFilter> getShareableEntityHandler;
    private final MessageBus messageBus;
    private final ShareableObjectsHandler aclHandler;

    @Autowired
    public DeleteUserFilterHandlerImpl(UserFilterRepository userFilterRepository, GetUserFilterHandler getFilterHandler, GetShareableEntityHandler<UserFilter> getShareableEntityHandler, MessageBus messageBus, ShareableObjectsHandler aclHandler) {
        this.userFilterRepository = userFilterRepository;
        this.getShareableEntityHandler = getShareableEntityHandler;
        this.messageBus = messageBus;
        this.aclHandler = aclHandler;
    }

    @Override
    public OperationCompletionRS deleteFilter(Long id, ReportPortalUser.ProjectDetails projectDetails, ReportPortalUser user) {
        UserFilter userFilter = this.getShareableEntityHandler.getAdministrated(id, projectDetails);
        BusinessRule.expect((Object)userFilter.getProject().getId(), Predicate.isEqual(projectDetails.getProjectId())).verify(ErrorType.USER_FILTER_NOT_FOUND, new Object[]{id, projectDetails.getProjectId(), user.getUserId()});
        this.userFilterRepository.delete((Object)userFilter);
        this.aclHandler.deleteAclForObject(userFilter);
        this.messageBus.publishActivity(new FilterDeletedEvent(UserFilterConverter.TO_ACTIVITY_RESOURCE.apply(userFilter), user.getUserId(), user.getUsername()));
        return new OperationCompletionRS("User filter with ID = '" + id + "' successfully deleted.");
    }
}

