/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.hierarchy;

import com.epam.ta.reportportal.commons.EntityUtils;
import com.epam.ta.reportportal.commons.ReportPortalUser;
import com.epam.ta.reportportal.commons.validation.BusinessRule;
import com.epam.ta.reportportal.core.hierarchy.FinishHierarchyHandler;
import com.epam.ta.reportportal.core.item.impl.IssueTypeHandler;
import com.epam.ta.reportportal.core.item.impl.status.ChangeStatusHandler;
import com.epam.ta.reportportal.dao.IssueEntityRepository;
import com.epam.ta.reportportal.dao.ItemAttributeRepository;
import com.epam.ta.reportportal.dao.LaunchRepository;
import com.epam.ta.reportportal.dao.TestItemRepository;
import com.epam.ta.reportportal.entity.ItemAttribute;
import com.epam.ta.reportportal.entity.enums.StatusEnum;
import com.epam.ta.reportportal.entity.enums.TestItemIssueGroup;
import com.epam.ta.reportportal.entity.enums.TestItemTypeEnum;
import com.epam.ta.reportportal.entity.item.TestItem;
import com.epam.ta.reportportal.entity.item.issue.IssueEntity;
import com.epam.ta.reportportal.entity.item.issue.IssueType;
import com.epam.ta.reportportal.ws.model.ErrorType;
import java.time.LocalDateTime;
import java.util.Date;
import java.util.Optional;
import java.util.stream.Stream;
import org.apache.commons.lang3.BooleanUtils;

public abstract class AbstractFinishHierarchyHandler<T>
implements FinishHierarchyHandler<T> {
    public static final String ATTRIBUTE_KEY_STATUS = "status";
    public static final String ATTRIBUTE_VALUE_INTERRUPTED = "interrupted";
    protected final LaunchRepository launchRepository;
    protected final TestItemRepository testItemRepository;
    protected final ItemAttributeRepository itemAttributeRepository;
    protected final IssueEntityRepository issueEntityRepository;
    private final IssueTypeHandler issueTypeHandler;
    private final ChangeStatusHandler changeStatusHandler;

    public AbstractFinishHierarchyHandler(LaunchRepository launchRepository, TestItemRepository testItemRepository, ItemAttributeRepository itemAttributeRepository, IssueEntityRepository issueEntityRepository, IssueTypeHandler issueTypeHandler, ChangeStatusHandler changeStatusHandler) {
        this.launchRepository = launchRepository;
        this.testItemRepository = testItemRepository;
        this.itemAttributeRepository = itemAttributeRepository;
        this.issueEntityRepository = issueEntityRepository;
        this.issueTypeHandler = issueTypeHandler;
        this.changeStatusHandler = changeStatusHandler;
    }

    protected abstract boolean isIssueRequired(StatusEnum var1, T var2);

    protected abstract Stream<Long> retrieveItemIds(T var1, StatusEnum var2, boolean var3);

    @Override
    public void finishDescendants(T entity, StatusEnum status, Date endDate, ReportPortalUser user, ReportPortalUser.ProjectDetails projectDetails) {
        BusinessRule.expect((Object)status, s -> s != StatusEnum.IN_PROGRESS).verify(ErrorType.INCORRECT_REQUEST, new Object[]{"Unable to update current status to - " + StatusEnum.IN_PROGRESS});
        LocalDateTime endTime = (LocalDateTime)EntityUtils.TO_LOCAL_DATE_TIME.apply(endDate);
        boolean isIssueRequired = this.isIssueRequired(status, entity);
        this.updateDescendantsWithoutChildren(entity, projectDetails.getProjectId(), status, endTime, isIssueRequired, user);
        this.updateDescendantsWithChildren(entity, endTime);
    }

    protected boolean evaluateSkippedAttributeValue(StatusEnum status, Long launchId) {
        if (StatusEnum.SKIPPED.equals((Object)status)) {
            return this.itemAttributeRepository.findByLaunchIdAndKeyAndSystem(launchId, "skippedIssue", true).map(attribute -> BooleanUtils.toBoolean((String)attribute.getValue())).orElse(false);
        }
        return false;
    }

    protected Optional<IssueType> getIssueType(boolean isIssueRequired, Long projectId, String locator) {
        if (isIssueRequired) {
            return Optional.of(this.issueTypeHandler.defineIssueType(projectId, locator));
        }
        return Optional.empty();
    }

    private void updateDescendantsWithoutChildren(T entity, Long projectId, StatusEnum status, LocalDateTime endTime, boolean isIssueRequired, ReportPortalUser user) {
        Optional<IssueType> issueType = this.getIssueType(isIssueRequired, projectId, TestItemIssueGroup.TO_INVESTIGATE.getLocator());
        this.retrieveItemIds(entity, StatusEnum.IN_PROGRESS, false).forEach(itemId -> this.testItemRepository.findById(itemId).ifPresent(testItem -> {
            this.finishItem((TestItem)testItem, status, endTime);
            issueType.ifPresent(it -> {
                if (!TestItemTypeEnum.SUITE.sameLevel(testItem.getType()) && testItem.isHasStats()) {
                    IssueEntity issueEntity = new IssueEntity();
                    issueEntity.setIssueType(it);
                    issueEntity.setTestItemResults(testItem.getItemResults());
                    this.issueEntityRepository.save((Object)issueEntity);
                    testItem.getItemResults().setIssue(issueEntity);
                }
            });
            this.changeStatusHandler.changeParentStatus((Long)itemId, projectId, user);
        }));
    }

    private void updateDescendantsWithChildren(T entity, LocalDateTime endTime) {
        this.retrieveItemIds(entity, StatusEnum.IN_PROGRESS, true).forEach(itemId -> this.testItemRepository.findById(itemId).ifPresent(testItem -> {
            boolean isFailed = this.testItemRepository.hasDescendantsWithStatusNotEqual(itemId, StatusEnum.PASSED);
            this.finishItem((TestItem)testItem, isFailed ? StatusEnum.FAILED : StatusEnum.PASSED, endTime);
        }));
    }

    private void finishItem(TestItem testItem, StatusEnum status, LocalDateTime endTime) {
        testItem.getItemResults().setStatus(status);
        testItem.getItemResults().setEndTime(endTime);
        ItemAttribute interruptedAttribute = new ItemAttribute(ATTRIBUTE_KEY_STATUS, ATTRIBUTE_VALUE_INTERRUPTED, Boolean.valueOf(false));
        interruptedAttribute.setTestItem(testItem);
        testItem.getAttributes().add(interruptedAttribute);
    }
}

