/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.integration.impl;

import com.epam.ta.reportportal.commons.ReportPortalUser;
import com.epam.ta.reportportal.commons.validation.BusinessRule;
import com.epam.ta.reportportal.commons.validation.Suppliers;
import com.epam.ta.reportportal.core.events.MessageBus;
import com.epam.ta.reportportal.core.events.activity.IntegrationCreatedEvent;
import com.epam.ta.reportportal.core.events.activity.IntegrationUpdatedEvent;
import com.epam.ta.reportportal.core.integration.CreateIntegrationHandler;
import com.epam.ta.reportportal.core.integration.util.IntegrationService;
import com.epam.ta.reportportal.dao.IntegrationRepository;
import com.epam.ta.reportportal.dao.IntegrationTypeRepository;
import com.epam.ta.reportportal.dao.ProjectRepository;
import com.epam.ta.reportportal.entity.integration.Integration;
import com.epam.ta.reportportal.entity.integration.IntegrationType;
import com.epam.ta.reportportal.entity.project.Project;
import com.epam.ta.reportportal.exception.ReportPortalException;
import com.epam.ta.reportportal.ws.converter.converters.IntegrationConverter;
import com.epam.ta.reportportal.ws.model.EntryCreatedRS;
import com.epam.ta.reportportal.ws.model.ErrorType;
import com.epam.ta.reportportal.ws.model.OperationCompletionRS;
import com.epam.ta.reportportal.ws.model.activity.IntegrationActivityResource;
import com.epam.ta.reportportal.ws.model.integration.IntegrationRQ;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
public class CreateIntegrationHandlerImpl
implements CreateIntegrationHandler {
    private final Map<String, IntegrationService> integrationServiceMapping;
    private final IntegrationRepository integrationRepository;
    private final ProjectRepository projectRepository;
    private final MessageBus messageBus;
    private final IntegrationTypeRepository integrationTypeRepository;
    private final IntegrationService basicIntegrationService;

    @Autowired
    public CreateIntegrationHandlerImpl(@Qualifier(value="integrationServiceMapping") Map<String, IntegrationService> integrationServiceMapping, IntegrationRepository integrationRepository, ProjectRepository projectRepository, MessageBus messageBus, IntegrationTypeRepository integrationTypeRepository, @Qualifier(value="basicIntegrationServiceImpl") IntegrationService integrationService) {
        this.integrationServiceMapping = integrationServiceMapping;
        this.integrationRepository = integrationRepository;
        this.projectRepository = projectRepository;
        this.messageBus = messageBus;
        this.integrationTypeRepository = integrationTypeRepository;
        this.basicIntegrationService = integrationService;
    }

    @Override
    public EntryCreatedRS createGlobalIntegration(IntegrationRQ createRequest, String pluginName, ReportPortalUser user) {
        IntegrationType integrationType = (IntegrationType)this.integrationTypeRepository.findByName(pluginName).orElseThrow(() -> new ReportPortalException(ErrorType.INTEGRATION_NOT_FOUND, new Object[]{pluginName}));
        IntegrationService integrationService = this.integrationServiceMapping.getOrDefault(integrationType.getName(), this.basicIntegrationService);
        String integrationName = Optional.ofNullable(createRequest.getName()).map(String::toLowerCase).map(name -> {
            this.validateGlobalIntegrationName((String)name, integrationType);
            return name;
        }).orElseThrow(() -> new ReportPortalException(ErrorType.INCORRECT_INTEGRATION_NAME, new Object[]{"Integration name should be not null"}));
        createRequest.setName(integrationName);
        Integration integration = integrationService.createIntegration(createRequest, integrationType);
        integration.setCreator(user.getUsername());
        integrationService.validateIntegration(integration);
        integrationService.checkConnection(integration);
        this.integrationRepository.save((Object)integration);
        return new EntryCreatedRS(integration.getId());
    }

    @Override
    public EntryCreatedRS createProjectIntegration(String projectName, IntegrationRQ createRequest, String pluginName, ReportPortalUser user) {
        Project project = (Project)this.projectRepository.findByName(projectName).orElseThrow(() -> new ReportPortalException(ErrorType.PROJECT_NOT_FOUND, new Object[]{projectName}));
        IntegrationType integrationType = (IntegrationType)this.integrationTypeRepository.findByName(pluginName).orElseThrow(() -> new ReportPortalException(ErrorType.INTEGRATION_NOT_FOUND, new Object[]{pluginName}));
        IntegrationService integrationService = this.integrationServiceMapping.getOrDefault(integrationType.getName(), this.basicIntegrationService);
        String integrationName = Optional.ofNullable(createRequest.getName()).map(String::toLowerCase).map(name -> {
            this.validateProjectIntegrationName((String)name, integrationType, project);
            return name;
        }).orElseThrow(() -> new ReportPortalException(ErrorType.INCORRECT_INTEGRATION_NAME, new Object[]{"Integration name should be not null"}));
        createRequest.setName(integrationName);
        Integration integration = integrationService.createIntegration(createRequest, integrationType);
        integration.setProject(project);
        integration.setCreator(user.getUsername());
        integrationService.validateIntegration(integration, project);
        integrationService.checkConnection(integration);
        this.integrationRepository.save((Object)integration);
        this.messageBus.publishActivity(new IntegrationCreatedEvent(IntegrationConverter.TO_ACTIVITY_RESOURCE.apply(integration), user.getUserId(), user.getUsername()));
        return new EntryCreatedRS(integration.getId());
    }

    @Override
    public OperationCompletionRS updateGlobalIntegration(Long id, IntegrationRQ updateRequest) {
        Integration integration = (Integration)this.integrationRepository.findGlobalById(id).orElseThrow(() -> new ReportPortalException(ErrorType.INTEGRATION_NOT_FOUND, new Object[]{id}));
        Optional.ofNullable(updateRequest.getName()).map(String::toLowerCase).ifPresent(name -> {
            if (!name.equals(integration.getName())) {
                this.validateGlobalIntegrationName((String)name, integration.getType());
                updateRequest.setName(name);
            }
        });
        IntegrationService integrationService = this.integrationServiceMapping.getOrDefault(integration.getType().getName(), this.basicIntegrationService);
        Integration updatedIntegration = integrationService.updateIntegration(integration, updateRequest);
        integrationService.checkConnection(integration);
        this.integrationRepository.save((Object)updatedIntegration);
        return new OperationCompletionRS("Integration with id = " + updatedIntegration.getId() + " has been successfully updated.");
    }

    @Override
    public OperationCompletionRS updateProjectIntegration(Long id, String projectName, IntegrationRQ updateRequest, ReportPortalUser user) {
        Project project = (Project)this.projectRepository.findByName(projectName).orElseThrow(() -> new ReportPortalException(ErrorType.PROJECT_NOT_FOUND, new Object[]{projectName}));
        Integration integration = (Integration)this.integrationRepository.findByIdAndProjectId(id, project.getId()).orElseThrow(() -> new ReportPortalException(ErrorType.INTEGRATION_NOT_FOUND, new Object[]{id}));
        IntegrationActivityResource beforeUpdate = IntegrationConverter.TO_ACTIVITY_RESOURCE.apply(integration);
        Optional.ofNullable(updateRequest.getName()).map(String::toLowerCase).ifPresent(name -> {
            if (!name.equals(integration.getName())) {
                this.validateProjectIntegrationName((String)name, integration.getType(), project);
                updateRequest.setName(name);
            }
        });
        IntegrationService integrationService = this.integrationServiceMapping.getOrDefault(integration.getType().getName(), this.basicIntegrationService);
        Integration updatedIntegration = integrationService.updateIntegration(integration, updateRequest);
        updatedIntegration.setProject(project);
        integrationService.checkConnection(integration);
        this.integrationRepository.save((Object)updatedIntegration);
        this.messageBus.publishActivity(new IntegrationUpdatedEvent(user.getUserId(), user.getUsername(), beforeUpdate, IntegrationConverter.TO_ACTIVITY_RESOURCE.apply(updatedIntegration)));
        return new OperationCompletionRS("Integration with id = " + updatedIntegration.getId() + " has been successfully updated.");
    }

    private void validateGlobalIntegrationName(String integrationName, IntegrationType integrationType) {
        BusinessRule.expect((Object)integrationName, StringUtils::isNotBlank).verify(ErrorType.INCORRECT_INTEGRATION_NAME, new Object[]{"Integration name should be not empty"});
        BusinessRule.expect((Object)this.integrationRepository.existsByNameAndTypeIdAndProjectIdIsNull(integrationName, integrationType.getId()), BooleanUtils::isFalse).verify(ErrorType.INTEGRATION_ALREADY_EXISTS, new Object[]{Suppliers.formattedSupplier((String)"Global integration of type = '{}' with name = '{}' already exists", (Object[])new Object[]{integrationType.getName(), integrationName})});
    }

    private void validateProjectIntegrationName(String integrationName, IntegrationType integrationType, Project project) {
        BusinessRule.expect((Object)integrationName, StringUtils::isNotBlank).verify(ErrorType.INCORRECT_INTEGRATION_NAME, new Object[]{"Integration name should be not empty"});
        BusinessRule.expect((Object)this.integrationRepository.existsByNameAndTypeIdAndProjectId(integrationName, integrationType.getId(), project.getId()), BooleanUtils::isFalse).verify(ErrorType.INTEGRATION_ALREADY_EXISTS, new Object[]{Suppliers.formattedSupplier((String)"Project integration of type = '{}' with name = '{}' already exists on project = '{}'", (Object[])new Object[]{integrationType.getName(), integrationName, project.getName()})});
    }
}

