/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.integration.util;

import com.epam.ta.reportportal.commons.validation.BusinessRule;
import com.epam.ta.reportportal.core.integration.util.BasicIntegrationServiceImpl;
import com.epam.ta.reportportal.core.integration.util.property.SauceLabsProperties;
import com.epam.ta.reportportal.core.plugin.PluginBox;
import com.epam.ta.reportportal.dao.IntegrationRepository;
import com.epam.ta.reportportal.entity.integration.Integration;
import com.epam.ta.reportportal.exception.ReportPortalException;
import com.epam.ta.reportportal.ws.model.ErrorType;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.collections4.MapUtils;
import org.jasypt.util.text.BasicTextEncryptor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SauceLabsIntegrationService
extends BasicIntegrationServiceImpl {
    private final BasicTextEncryptor encryptor;

    @Autowired
    public SauceLabsIntegrationService(IntegrationRepository integrationRepository, PluginBox pluginBox, BasicTextEncryptor encryptor) {
        super(integrationRepository, pluginBox);
        this.encryptor = encryptor;
    }

    @Override
    public Map<String, Object> retrieveIntegrationParams(Map<String, Object> integrationParams) {
        BusinessRule.expect(integrationParams, MapUtils::isNotEmpty).verify(ErrorType.BAD_REQUEST_ERROR, new Object[]{"No integration params provided"});
        String encryptedToken = this.encryptor.encrypt(SauceLabsProperties.ACCESS_TOKEN.getParameter(integrationParams).orElseThrow(() -> new ReportPortalException(ErrorType.BAD_REQUEST_ERROR, new Object[]{"AccessKey value cannot be NULL"})));
        String username = SauceLabsProperties.USERNAME.getParameter(integrationParams).orElseThrow(() -> new ReportPortalException(ErrorType.BAD_REQUEST_ERROR, new Object[]{"Username is not specified"}));
        HashMap result = Maps.newHashMap();
        result.put(SauceLabsProperties.ACCESS_TOKEN.getName(), encryptedToken);
        result.put(SauceLabsProperties.USERNAME.getName(), username);
        integrationParams.entrySet().stream().filter(it -> !((String)it.getKey()).equals(SauceLabsProperties.ACCESS_TOKEN.getName()) && !((String)it.getKey()).equals(SauceLabsProperties.USERNAME.getName())).forEach(it -> result.put((String)it.getKey(), it.getValue()));
        return result;
    }

    @Override
    public boolean checkConnection(Integration integration) {
        this.decryptParams(integration);
        boolean connection = super.checkConnection(integration);
        SauceLabsProperties.ACCESS_TOKEN.getParameter(integration.getParams().getParams()).ifPresent(it -> SauceLabsProperties.ACCESS_TOKEN.setParameter(integration.getParams(), this.encryptor.encrypt(it)));
        return connection;
    }

    @Override
    public void decryptParams(Integration integration) {
        SauceLabsProperties.ACCESS_TOKEN.getParameter(integration.getParams().getParams()).ifPresent(it -> SauceLabsProperties.ACCESS_TOKEN.setParameter(integration.getParams(), this.encryptor.decrypt(it)));
    }
}

