/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.item;

import com.epam.ta.reportportal.dao.LaunchRepository;
import com.epam.ta.reportportal.dao.TestItemRepository;
import com.epam.ta.reportportal.entity.item.TestItem;
import com.epam.ta.reportportal.entity.launch.Launch;
import com.epam.ta.reportportal.exception.ReportPortalException;
import com.epam.ta.reportportal.ws.model.ErrorType;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TestItemService {
    private final TestItemRepository testItemRepository;
    private final LaunchRepository launchRepository;

    @Autowired
    public TestItemService(TestItemRepository testItemRepository, LaunchRepository launchRepository) {
        this.testItemRepository = testItemRepository;
        this.launchRepository = launchRepository;
    }

    public Launch getEffectiveLaunch(TestItem testItem) {
        return (Launch)Optional.ofNullable(testItem.getRetryOf()).map(retryParentId -> {
            TestItem retryParent = (TestItem)this.testItemRepository.findById(retryParentId).orElseThrow(() -> new ReportPortalException(ErrorType.TEST_ITEM_NOT_FOUND, new Object[]{testItem.getRetryOf()}));
            return this.getLaunch(retryParent);
        }).orElseGet(() -> this.getLaunch(testItem)).orElseThrow(() -> new ReportPortalException(ErrorType.LAUNCH_NOT_FOUND, new Object[0]));
    }

    private Optional<Launch> getLaunch(TestItem testItem) {
        return Optional.ofNullable(testItem.getLaunchId()).map(arg_0 -> ((LaunchRepository)this.launchRepository).findById(arg_0)).orElseGet(() -> Optional.ofNullable(testItem.getParent()).map(TestItem::getLaunchId).map(arg_0 -> ((LaunchRepository)this.launchRepository).findById(arg_0)).orElseThrow(() -> new ReportPortalException(ErrorType.LAUNCH_NOT_FOUND, new Object[0])));
    }
}

