/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.item.impl;

import com.epam.ta.reportportal.commons.Predicates;
import com.epam.ta.reportportal.commons.ReportPortalUser;
import com.epam.ta.reportportal.commons.querygen.Condition;
import com.epam.ta.reportportal.commons.querygen.ConvertibleCondition;
import com.epam.ta.reportportal.commons.querygen.Filter;
import com.epam.ta.reportportal.commons.querygen.FilterCondition;
import com.epam.ta.reportportal.commons.querygen.Queryable;
import com.epam.ta.reportportal.commons.validation.BusinessRule;
import com.epam.ta.reportportal.commons.validation.Suppliers;
import com.epam.ta.reportportal.core.item.GetTestItemHandler;
import com.epam.ta.reportportal.core.item.impl.LaunchAccessValidator;
import com.epam.ta.reportportal.core.item.utils.DefaultLaunchFilterProvider;
import com.epam.ta.reportportal.core.shareable.GetShareableEntityHandler;
import com.epam.ta.reportportal.dao.ItemAttributeRepository;
import com.epam.ta.reportportal.dao.TestItemRepository;
import com.epam.ta.reportportal.dao.TicketRepository;
import com.epam.ta.reportportal.entity.enums.LaunchModeEnum;
import com.epam.ta.reportportal.entity.filter.UserFilter;
import com.epam.ta.reportportal.entity.item.TestItem;
import com.epam.ta.reportportal.entity.project.ProjectRole;
import com.epam.ta.reportportal.entity.user.UserRole;
import com.epam.ta.reportportal.exception.ReportPortalException;
import com.epam.ta.reportportal.ws.converter.PagedResourcesAssembler;
import com.epam.ta.reportportal.ws.converter.converters.TestItemConverter;
import com.epam.ta.reportportal.ws.converter.utils.ResourceUpdater;
import com.epam.ta.reportportal.ws.converter.utils.ResourceUpdaterProvider;
import com.epam.ta.reportportal.ws.converter.utils.item.content.TestItemUpdaterContent;
import com.epam.ta.reportportal.ws.model.ErrorType;
import com.epam.ta.reportportal.ws.model.TestItemResource;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.commons.lang3.tuple.Pair;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

@Service
class GetTestItemHandlerImpl
implements GetTestItemHandler {
    private final TestItemRepository testItemRepository;
    private final LaunchAccessValidator launchAccessValidator;
    private final ItemAttributeRepository itemAttributeRepository;
    private final List<ResourceUpdaterProvider<TestItemUpdaterContent, TestItemResource>> resourceUpdaterProviders;
    private final TicketRepository ticketRepository;
    private final GetShareableEntityHandler<UserFilter> getShareableEntityHandler;

    @Autowired
    public GetTestItemHandlerImpl(TestItemRepository testItemRepository, LaunchAccessValidator launchAccessValidator, ItemAttributeRepository itemAttributeRepository, List<ResourceUpdaterProvider<TestItemUpdaterContent, TestItemResource>> resourceUpdaterProviders, TicketRepository ticketRepository, GetShareableEntityHandler<UserFilter> getShareableEntityHandler1) {
        this.testItemRepository = testItemRepository;
        this.launchAccessValidator = launchAccessValidator;
        this.itemAttributeRepository = itemAttributeRepository;
        this.resourceUpdaterProviders = resourceUpdaterProviders;
        this.ticketRepository = ticketRepository;
        this.getShareableEntityHandler = getShareableEntityHandler1;
    }

    @Override
    public TestItemResource getTestItem(String testItemId, ReportPortalUser.ProjectDetails projectDetails, ReportPortalUser user) {
        TestItem testItem;
        try {
            testItem = (TestItem)this.testItemRepository.findById((Object)Long.parseLong(testItemId)).orElseThrow(() -> new ReportPortalException(ErrorType.TEST_ITEM_NOT_FOUND, new Object[]{testItemId}));
        }
        catch (NumberFormatException e) {
            testItem = (TestItem)this.testItemRepository.findByUuid(testItemId).orElseThrow(() -> new ReportPortalException(ErrorType.TEST_ITEM_NOT_FOUND, new Object[]{testItemId}));
        }
        this.launchAccessValidator.validate(testItem.getLaunchId(), projectDetails, user);
        List<ResourceUpdater<TestItemResource>> resourceUpdaters = this.getResourceUpdaters(projectDetails.getProjectId(), Collections.singletonList(testItem));
        TestItemResource testItemResource = TestItemConverter.TO_RESOURCE.apply(testItem);
        resourceUpdaters.forEach(updater -> updater.updateResource(testItemResource));
        return testItemResource;
    }

    @Override
    public Iterable<TestItemResource> getTestItems(Queryable filter, Pageable pageable, ReportPortalUser.ProjectDetails projectDetails, ReportPortalUser user, @Nullable Long launchId, @Nullable Long filterId, boolean isLatest, int launchesLimit) {
        Optional<Long> launchIdOptional = Optional.ofNullable(launchId);
        Optional<Long> filterIdOptional = Optional.ofNullable(filterId);
        Page testItemPage = filterIdOptional.map(launchFilterId -> {
            this.validateProjectRole(projectDetails, user);
            return this.getItemsWithLaunchesFiltering(filter, pageable, projectDetails, (Long)launchFilterId, isLatest, launchesLimit);
        }).orElseGet(() -> launchIdOptional.map(id -> {
            this.launchAccessValidator.validate((Long)id, projectDetails, user);
            return this.testItemRepository.findByFilter(filter, pageable);
        }).orElseThrow(() -> new ReportPortalException(ErrorType.BAD_REQUEST_ERROR, new Object[]{"Neither launch nor filter id specified."})));
        return (Iterable)PagedResourcesAssembler.pageMultiConverter(items -> {
            List<ResourceUpdater<TestItemResource>> resourceUpdaters = this.getResourceUpdaters(projectDetails.getProjectId(), testItemPage.getContent());
            return items.stream().map(item -> {
                TestItemResource testItemResource = TestItemConverter.TO_RESOURCE.apply((TestItem)item);
                resourceUpdaters.forEach(updater -> updater.updateResource(testItemResource));
                return testItemResource;
            }).collect(Collectors.toList());
        }).apply(testItemPage);
    }

    protected void validateProjectRole(ReportPortalUser.ProjectDetails projectDetails, ReportPortalUser user) {
        if (user.getUserRole() != UserRole.ADMINISTRATOR) {
            BusinessRule.expect((Object)(projectDetails.getProjectRole() == ProjectRole.OPERATOR ? 1 : 0), Predicate.isEqual(false)).verify(ErrorType.ACCESS_DENIED, new Object[0]);
        }
    }

    private Page<TestItem> getItemsWithLaunchesFiltering(Queryable testItemFilter, Pageable testItemPageable, ReportPortalUser.ProjectDetails projectDetails, Long launchFilterId, boolean isLatest, int launchesLimit) {
        Pair<Queryable, Pageable> queryablePair = DefaultLaunchFilterProvider.createDefaultLaunchQueryablePair(projectDetails, this.getShareableEntityHandler.getPermitted(launchFilterId, projectDetails), launchesLimit);
        return this.testItemRepository.findByFilter(isLatest, (Queryable)queryablePair.getKey(), testItemFilter, (Pageable)queryablePair.getValue(), testItemPageable);
    }

    private List<ResourceUpdater<TestItemResource>> getResourceUpdaters(Long projectId, List<TestItem> testItems) {
        return this.resourceUpdaterProviders.stream().map(retriever -> retriever.retrieve(TestItemUpdaterContent.of(projectId, testItems))).collect(Collectors.toList());
    }

    @Override
    public List<String> getTicketIds(Long launchId, String term) {
        BusinessRule.expect((Object)(term.length() > 2 ? 1 : 0), (Predicate)Predicates.equalTo((Object)true)).verify(ErrorType.INCORRECT_FILTER_PARAMETERS, new Object[]{Suppliers.formattedSupplier((String)"Length of the filtering string '{}' is less than 3 symbols", (Object[])new Object[]{term})});
        return this.ticketRepository.findByTerm(launchId, term);
    }

    @Override
    public List<String> getAttributeKeys(Long launchFilterId, boolean isLatest, int launchesLimit, ReportPortalUser.ProjectDetails projectDetails, String keyPart) {
        Pair<Queryable, Pageable> queryablePair = DefaultLaunchFilterProvider.createDefaultLaunchQueryablePair(projectDetails, this.getShareableEntityHandler.getPermitted(launchFilterId, projectDetails), launchesLimit);
        return this.itemAttributeRepository.findAllKeysByLaunchFilter((Queryable)queryablePair.getKey(), (Pageable)queryablePair.getValue(), isLatest, keyPart, false);
    }

    @Override
    public List<String> getAttributeKeys(Long launchId, String value) {
        return this.itemAttributeRepository.findTestItemAttributeKeys(launchId, value, false);
    }

    @Override
    public List<String> getAttributeValues(Long launchId, String key, String value) {
        return this.itemAttributeRepository.findTestItemAttributeValues(launchId, key, value, false);
    }

    @Override
    public List<TestItemResource> getTestItems(Long[] ids, ReportPortalUser.ProjectDetails projectDetails, ReportPortalUser user) {
        List items = user.getUserRole() != UserRole.ADMINISTRATOR ? this.testItemRepository.findByFilter((Queryable)this.getItemsFilter(ids, projectDetails)) : this.testItemRepository.findAllById(Arrays.asList(ids));
        List<ResourceUpdater<TestItemResource>> resourceUpdaters = this.getResourceUpdaters(projectDetails.getProjectId(), items);
        return items.stream().map(item -> {
            TestItemResource testItemResource = TestItemConverter.TO_RESOURCE.apply((TestItem)item);
            resourceUpdaters.forEach(updater -> updater.updateResource(testItemResource));
            return testItemResource;
        }).collect(Collectors.toList());
    }

    private Filter getItemsFilter(Long[] ids, ReportPortalUser.ProjectDetails projectDetails) {
        Filter filter = Filter.builder().withTarget(TestItem.class).withCondition((ConvertibleCondition)FilterCondition.builder().eq("projectId", String.valueOf(projectDetails.getProjectId())).build()).withCondition((ConvertibleCondition)FilterCondition.builder().withSearchCriteria("id").withCondition(Condition.IN).withValue(Arrays.stream(ids).map(Object::toString).collect(Collectors.joining(","))).build()).build();
        return projectDetails.getProjectRole() != ProjectRole.OPERATOR ? filter : filter.withCondition((ConvertibleCondition)FilterCondition.builder().eq("mode", LaunchModeEnum.DEFAULT.name()).build());
    }
}

