/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.item.impl.status;

import com.epam.ta.reportportal.commons.ReportPortalUser;
import com.epam.ta.reportportal.commons.validation.BusinessRule;
import com.epam.ta.reportportal.commons.validation.Suppliers;
import com.epam.ta.reportportal.core.analyzer.auto.LogIndexer;
import com.epam.ta.reportportal.core.events.MessageBus;
import com.epam.ta.reportportal.core.events.activity.TestItemStatusChangedEvent;
import com.epam.ta.reportportal.core.item.impl.IssueTypeHandler;
import com.epam.ta.reportportal.core.item.impl.status.StatusChangingStrategy;
import com.epam.ta.reportportal.dao.IssueEntityRepository;
import com.epam.ta.reportportal.dao.LaunchRepository;
import com.epam.ta.reportportal.dao.LogRepository;
import com.epam.ta.reportportal.dao.ProjectRepository;
import com.epam.ta.reportportal.entity.enums.LogLevel;
import com.epam.ta.reportportal.entity.enums.StatusEnum;
import com.epam.ta.reportportal.entity.enums.TestItemIssueGroup;
import com.epam.ta.reportportal.entity.item.TestItem;
import com.epam.ta.reportportal.entity.item.issue.IssueEntity;
import com.epam.ta.reportportal.entity.item.issue.IssueType;
import com.epam.ta.reportportal.entity.launch.Launch;
import com.epam.ta.reportportal.entity.project.Project;
import com.epam.ta.reportportal.exception.ReportPortalException;
import com.epam.ta.reportportal.ws.converter.converters.TestItemConverter;
import com.epam.ta.reportportal.ws.model.ErrorType;
import com.epam.ta.reportportal.ws.model.activity.TestItemActivityResource;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

public abstract class AbstractStatusChangingStrategy
implements StatusChangingStrategy {
    private final ProjectRepository projectRepository;
    private final LaunchRepository launchRepository;
    private final IssueTypeHandler issueTypeHandler;
    private final MessageBus messageBus;
    protected final IssueEntityRepository issueEntityRepository;
    protected final LogRepository logRepository;
    protected final LogIndexer logIndexer;

    protected AbstractStatusChangingStrategy(ProjectRepository projectRepository, LaunchRepository launchRepository, IssueTypeHandler issueTypeHandler, MessageBus messageBus, IssueEntityRepository issueEntityRepository, LogRepository logRepository, LogIndexer logIndexer) {
        this.projectRepository = projectRepository;
        this.launchRepository = launchRepository;
        this.issueTypeHandler = issueTypeHandler;
        this.messageBus = messageBus;
        this.issueEntityRepository = issueEntityRepository;
        this.logRepository = logRepository;
        this.logIndexer = logIndexer;
    }

    protected abstract void updateStatus(Project var1, Launch var2, TestItem var3, StatusEnum var4, ReportPortalUser var5);

    protected abstract StatusEnum evaluateParentItemStatus(TestItem var1, TestItem var2);

    @Override
    public void changeStatus(TestItem testItem, StatusEnum providedStatus, ReportPortalUser user) {
        BusinessRule.expect((Object)testItem.getItemResults().getStatus(), currentStatus -> !StatusEnum.IN_PROGRESS.equals(currentStatus)).verify(ErrorType.INCORRECT_REQUEST, new Object[]{Suppliers.formattedSupplier((String)"Unable to update status of test item = '{}' because of '{}' status", (Object[])new Object[]{testItem.getItemId(), testItem.getItemResults().getStatus()}).get()});
        if (providedStatus == testItem.getItemResults().getStatus()) {
            return;
        }
        Launch launch = (Launch)this.launchRepository.findById((Object)testItem.getLaunchId()).orElseThrow(() -> new ReportPortalException(ErrorType.LAUNCH_NOT_FOUND, new Object[]{testItem.getLaunchId()}));
        Project project = (Project)this.projectRepository.findById((Object)launch.getProjectId()).orElseThrow(() -> new ReportPortalException(ErrorType.PROJECT_NOT_FOUND, new Object[]{launch.getProjectId()}));
        this.updateStatus(project, launch, testItem, providedStatus, user);
    }

    protected void addToInvestigateIssue(TestItem testItem, Long projectId) {
        IssueEntity issueEntity = new IssueEntity();
        IssueType toInvestigate = this.issueTypeHandler.defineIssueType(projectId, TestItemIssueGroup.TO_INVESTIGATE.getLocator());
        issueEntity.setIssueType(toInvestigate);
        issueEntity.setTestItemResults(testItem.getItemResults());
        this.issueEntityRepository.save((Object)issueEntity);
        testItem.getItemResults().setIssue(issueEntity);
    }

    protected List<Long> changeParentsStatuses(TestItem testItem, Launch launch, boolean issueRequired, ReportPortalUser user) {
        ArrayList updatedParents = Lists.newArrayList();
        for (TestItem parent = testItem.getParent(); parent != null; parent = parent.getParent()) {
            StatusEnum newParentStatus;
            StatusEnum currentParentStatus = parent.getItemResults().getStatus();
            if (!StatusEnum.IN_PROGRESS.equals((Object)currentParentStatus)) {
                newParentStatus = this.evaluateParentItemStatus(parent, testItem);
                if (currentParentStatus.equals((Object)newParentStatus)) {
                    return updatedParents;
                }
            } else {
                return updatedParents;
            }
            TestItemActivityResource before = TestItemConverter.TO_ACTIVITY_RESOURCE.apply(parent, launch.getProjectId());
            parent.getItemResults().setStatus(newParentStatus);
            this.updateItem(parent, launch.getProjectId(), issueRequired).ifPresent(updatedParents::add);
            this.publishUpdateActivity(before, TestItemConverter.TO_ACTIVITY_RESOURCE.apply(parent, launch.getProjectId()), user);
        }
        if (launch.getStatus() != StatusEnum.IN_PROGRESS) {
            launch.setStatus(this.launchRepository.hasRootItemsWithStatusNotEqual(launch.getId(), StatusEnum.PASSED) ? StatusEnum.FAILED : StatusEnum.PASSED);
        }
        return updatedParents;
    }

    private Optional<Long> updateItem(TestItem parent, Long projectId, boolean issueRequired) {
        if (parent.isHasStats() && !parent.isHasChildren()) {
            this.updateIssue(parent, projectId, issueRequired);
            return Optional.of(parent.getItemId());
        }
        return Optional.empty();
    }

    private void updateIssue(TestItem parent, Long projectId, boolean issueRequired) {
        if (issueRequired) {
            if (Optional.ofNullable(parent.getItemResults().getIssue()).isEmpty()) {
                this.addToInvestigateIssue(parent, projectId);
            }
        } else {
            Optional.ofNullable(parent.getItemResults().getIssue()).ifPresent(issue -> {
                issue.setTestItemResults(null);
                this.issueEntityRepository.delete(issue);
                parent.getItemResults().setIssue(null);
                this.logIndexer.cleanIndex(projectId, this.logRepository.findIdsUnderTestItemByLaunchIdAndTestItemIdsAndLogLevelGte(parent.getLaunchId(), Collections.singletonList(parent.getItemId()), LogLevel.ERROR.toInt()));
            });
        }
    }

    private void publishUpdateActivity(TestItemActivityResource before, TestItemActivityResource after, ReportPortalUser user) {
        this.messageBus.publishActivity(new TestItemStatusChangedEvent(before, after, user.getUserId(), user.getUsername()));
    }
}

