/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.jasper.util;

import com.epam.ta.reportportal.entity.item.TestItem;
import com.epam.ta.reportportal.entity.statistics.Statistics;
import java.time.Duration;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;

public class ExportUtils {
    private static final String SHIFT_PREFIX = "    ";
    public static final String COMMENT_PREFIX = "\r\n DEFECT COMMENT: ";
    public static final String DESCRIPTION_PREFIX = "\r\n ITEM DESCRIPTION: ";

    public static int getStatisticsCounter(Set<Statistics> statistics, String statisticsFieldName) {
        return statistics.stream().filter(it -> it.getStatisticsField().getName().equals(statisticsFieldName)).mapToInt(Statistics::getCounter).findAny().orElse(0);
    }

    public static String adjustName(TestItem input) {
        return StringUtils.repeat((String)SHIFT_PREFIX, (int)input.getPath().split("\\.").length) + input.getName();
    }

    public static String durationToShortDHMS(Duration duration) {
        long days = duration.toDays();
        long hours = duration.toHours() - TimeUnit.DAYS.toHours(days);
        long minutes = duration.toMinutes() - TimeUnit.HOURS.toMinutes(hours);
        long seconds = duration.getSeconds() - TimeUnit.MINUTES.toSeconds(minutes);
        return days == 0L ? String.format("%02d:%02d:%02d", hours, minutes, seconds) : String.format("%dd%02d:%02d:%02d", days, hours, minutes, seconds);
    }
}

