/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.launch.impl;

import com.epam.ta.reportportal.commons.ReportPortalUser;
import com.epam.ta.reportportal.core.launch.StartLaunchHandler;
import com.epam.ta.reportportal.util.ReportingQueueService;
import com.epam.ta.reportportal.ws.model.launch.StartLaunchRQ;
import com.epam.ta.reportportal.ws.model.launch.StartLaunchRS;
import com.epam.ta.reportportal.ws.rabbit.RequestType;
import java.util.Map;
import java.util.UUID;
import org.springframework.amqp.core.AmqpTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
@Qualifier(value="startLaunchHandlerAsync")
public class StartLaunchHandlerAsyncImpl
implements StartLaunchHandler {
    @Autowired
    @Qualifier(value="rabbitTemplate")
    AmqpTemplate amqpTemplate;
    @Autowired
    private ReportingQueueService reportingQueueService;

    @Override
    public StartLaunchRS startLaunch(ReportPortalUser user, ReportPortalUser.ProjectDetails projectDetails, StartLaunchRQ request) {
        this.validateRoles(projectDetails, request);
        if (request.getUuid() == null) {
            request.setUuid(UUID.randomUUID().toString());
        }
        this.amqpTemplate.convertAndSend("reporting", this.reportingQueueService.getReportingQueueKey(request.getUuid()), (Object)request, message -> {
            Map headers = message.getMessageProperties().getHeaders();
            headers.put("requestType", RequestType.START_LAUNCH);
            headers.put("username", user.getUsername());
            headers.put("projectName", projectDetails.getProjectName());
            return message;
        });
        StartLaunchRS response = new StartLaunchRS();
        response.setId(request.getUuid());
        return response;
    }
}

