/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.preference.impl;

import com.epam.ta.reportportal.commons.ReportPortalUser;
import com.epam.ta.reportportal.core.preference.UpdatePreferenceHandler;
import com.epam.ta.reportportal.core.shareable.GetShareableEntityHandler;
import com.epam.ta.reportportal.dao.UserPreferenceRepository;
import com.epam.ta.reportportal.entity.filter.UserFilter;
import com.epam.ta.reportportal.entity.preference.UserPreference;
import com.epam.ta.reportportal.exception.ReportPortalException;
import com.epam.ta.reportportal.ws.converter.builders.UserPreferenceBuilder;
import com.epam.ta.reportportal.ws.model.ErrorType;
import com.epam.ta.reportportal.ws.model.OperationCompletionRS;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UpdatePreferenceHandlerImpl
implements UpdatePreferenceHandler {
    private final UserPreferenceRepository userPreferenceRepository;
    private final GetShareableEntityHandler<UserFilter> getShareableEntityHandler;

    @Autowired
    public UpdatePreferenceHandlerImpl(UserPreferenceRepository userPreferenceRepository, GetShareableEntityHandler<UserFilter> getShareableEntityHandler) {
        this.userPreferenceRepository = userPreferenceRepository;
        this.getShareableEntityHandler = getShareableEntityHandler;
    }

    @Override
    public OperationCompletionRS addPreference(ReportPortalUser.ProjectDetails projectDetails, ReportPortalUser user, Long filterId) {
        if (this.userPreferenceRepository.findByProjectIdAndUserIdAndFilterId(projectDetails.getProjectId(), user.getUserId(), filterId).isPresent()) {
            throw new ReportPortalException(ErrorType.RESOURCE_ALREADY_EXISTS, new Object[]{"User Preference"});
        }
        UserFilter filter = this.getShareableEntityHandler.getPermitted(filterId, projectDetails);
        UserPreference userPreference = new UserPreferenceBuilder().withUser(user.getUserId()).withProject(projectDetails.getProjectId()).withFilter(filter).get();
        this.userPreferenceRepository.save((Object)userPreference);
        return new OperationCompletionRS("Filter with id = " + filterId + " successfully added to launches tab.");
    }

    @Override
    public OperationCompletionRS removePreference(ReportPortalUser.ProjectDetails projectDetails, ReportPortalUser user, Long filterId) {
        UserPreference userPreference = (UserPreference)this.userPreferenceRepository.findByProjectIdAndUserIdAndFilterId(projectDetails.getProjectId(), user.getUserId(), filterId).orElseThrow(() -> new ReportPortalException(ErrorType.USER_FILTER_NOT_FOUND, new Object[]{filterId}));
        this.userPreferenceRepository.delete((Object)userPreference);
        return new OperationCompletionRS("Filter with id = " + filterId + " successfully removed from launches tab.");
    }
}

