/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.project.impl;

import com.epam.ta.reportportal.core.events.MessageBus;
import com.epam.ta.reportportal.core.events.attachment.DeleteAttachmentEvent;
import com.epam.ta.reportportal.dao.AttachmentRepository;
import com.epam.ta.reportportal.job.PageUtil;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
public class AttachmentEventPublisher {
    private static final Integer ATTACHMENTS_BATCH_SIZE = 300;
    private final AttachmentRepository attachmentRepository;
    private final MessageBus messageBus;

    @Autowired
    public AttachmentEventPublisher(AttachmentRepository attachmentRepository, MessageBus messageBus) {
        this.attachmentRepository = attachmentRepository;
        this.messageBus = messageBus;
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW, readOnly=true)
    public void publishDeleteProjectAttachmentsEvent(Long projectId) {
        PageUtil.iterateOverPages(ATTACHMENTS_BATCH_SIZE, pageable -> this.attachmentRepository.findIdsByProjectId(projectId, pageable), this::publishDeleteAttachmentEvent);
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW, readOnly=true)
    public void publishDeleteLaunchAttachmentsEvent(Long launchId) {
        PageUtil.iterateOverPages(ATTACHMENTS_BATCH_SIZE, pageable -> this.attachmentRepository.findIdsByLaunchId(launchId, pageable), this::publishDeleteAttachmentEvent);
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW, readOnly=true)
    public void publishDeleteItemAttachmentsEvent(Long itemId) {
        PageUtil.iterateOverPages(ATTACHMENTS_BATCH_SIZE, pageable -> this.attachmentRepository.findIdsByTestItemId(itemId, pageable), this::publishDeleteAttachmentEvent);
    }

    private void publishDeleteAttachmentEvent(List<Long> ids) {
        this.messageBus.publishDeleteAttachmentEvent(new DeleteAttachmentEvent(ids));
    }
}

