/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.widget.content.loader;

import com.epam.ta.reportportal.commons.Predicates;
import com.epam.ta.reportportal.commons.querygen.Filter;
import com.epam.ta.reportportal.commons.validation.BusinessRule;
import com.epam.ta.reportportal.core.widget.content.LoadContentStrategy;
import com.epam.ta.reportportal.core.widget.util.ContentFieldMatcherUtil;
import com.epam.ta.reportportal.core.widget.util.ContentFieldPatternConstants;
import com.epam.ta.reportportal.core.widget.util.WidgetFilterUtil;
import com.epam.ta.reportportal.dao.WidgetContentRepository;
import com.epam.ta.reportportal.entity.widget.WidgetOptions;
import com.epam.ta.reportportal.ws.model.ErrorType;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;

@Service
public class LaunchesComparisonContentLoader
implements LoadContentStrategy {
    @Autowired
    private WidgetContentRepository widgetContentRepository;

    @Override
    public Map<String, ?> loadContent(List<String> contentFields, Map<Filter, Sort> filterSortMapping, WidgetOptions widgetOptions, int limit) {
        this.validateFilterSortMapping(filterSortMapping);
        this.validateContentFields(contentFields);
        Filter filter = WidgetFilterUtil.GROUP_FILTERS.apply(filterSortMapping.keySet());
        Sort sort = Sort.by((Sort.Order[])new Sort.Order[]{Sort.Order.desc((String)"startTime"), Sort.Order.desc((String)"number")});
        List result = this.widgetContentRepository.launchesComparisonStatistics(filter, contentFields, sort, limit);
        if (result.isEmpty()) {
            return Collections.emptyMap();
        }
        Collections.reverse(result);
        return Collections.singletonMap("result", result);
    }

    private void validateFilterSortMapping(Map<Filter, Sort> filterSortMapping) {
        BusinessRule.expect((Object)MapUtils.isNotEmpty(filterSortMapping), (Predicate)Predicates.equalTo((Object)true)).verify(ErrorType.BAD_REQUEST_ERROR, new Object[]{"Filter-Sort mapping should not be empty"});
    }

    private void validateContentFields(List<String> contentFields) {
        BusinessRule.expect((Object)CollectionUtils.isNotEmpty(contentFields), (Predicate)Predicates.equalTo((Object)true)).verify(ErrorType.BAD_REQUEST_ERROR, new Object[]{"Content fields should not be empty"});
        BusinessRule.expect((Object)ContentFieldMatcherUtil.match(ContentFieldPatternConstants.COMBINED_CONTENT_FIELDS_REGEX, contentFields), (Predicate)Predicates.equalTo((Object)true)).verify(ErrorType.BAD_REQUEST_ERROR, new Object[]{"Bad content fields format"});
    }
}

