/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.widget.content.loader;

import com.epam.ta.reportportal.commons.Predicates;
import com.epam.ta.reportportal.commons.querygen.Filter;
import com.epam.ta.reportportal.commons.validation.BusinessRule;
import com.epam.ta.reportportal.core.widget.content.loader.ProductStatusContentLoader;
import com.epam.ta.reportportal.core.widget.util.WidgetOptionUtil;
import com.epam.ta.reportportal.dao.WidgetContentRepository;
import com.epam.ta.reportportal.entity.widget.WidgetOptions;
import com.epam.ta.reportportal.ws.model.ErrorType;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;

@Service
public class ProductStatusFilterGroupedContentLoader
implements ProductStatusContentLoader {
    @Autowired
    private WidgetContentRepository widgetContentRepository;

    @Override
    public Map<String, ?> loadContent(List<String> contentFields, Map<Filter, Sort> filterSortMapping, WidgetOptions widgetOptions, int limit) {
        this.validateFilterSortMapping(filterSortMapping);
        Map attributeColumns = WidgetOptionUtil.getMapByKey("customColumns", widgetOptions);
        this.validateContentFields(contentFields);
        boolean latestMode = WidgetOptionUtil.getBooleanByKey("latest", widgetOptions);
        Map content = this.widgetContentRepository.productStatusGroupedByFilterStatistics(filterSortMapping, contentFields, attributeColumns, latestMode, limit);
        return content.isEmpty() ? Collections.emptyMap() : Collections.singletonMap("result", content);
    }

    private void validateFilterSortMapping(Map<Filter, Sort> filterSortMapping) {
        BusinessRule.expect((Object)MapUtils.isNotEmpty(filterSortMapping), (Predicate)Predicates.equalTo((Object)true)).verify(ErrorType.BAD_REQUEST_ERROR, new Object[]{"Filter-Sort mapping should not be empty"});
    }

    private void validateContentFields(List<String> contentFields) {
        BusinessRule.expect((Object)CollectionUtils.isNotEmpty(contentFields), (Predicate)Predicates.equalTo((Object)true)).verify(ErrorType.BAD_REQUEST_ERROR, new Object[]{"Content fields should not be empty"});
    }
}

