/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.demodata.service;

import com.epam.ta.reportportal.entity.enums.TestItemIssueGroup;
import com.epam.ta.reportportal.entity.enums.TestItemTypeEnum;
import com.epam.ta.reportportal.exception.ReportPortalException;
import com.epam.ta.reportportal.ws.model.attribute.ItemAttributesRQ;
import com.epam.ta.reportportal.ws.model.issue.Issue;
import com.google.common.base.CaseFormat;
import com.google.common.base.Preconditions;
import com.google.common.collect.Range;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Set;
import java.util.SplittableRandom;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.commons.lang3.tuple.Pair;
import org.springframework.core.io.ClassPathResource;

final class ContentUtils {
    private static final int MAX_ERROR_LOGS_COUNT = 2;
    private static final int ERRORS_COUNT = 9;
    private static final Range<Integer> PROBABILITY_RANGE = Range.openClosed((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(100));
    private static SplittableRandom random = new SplittableRandom();

    private ContentUtils() {
    }

    static Set<ItemAttributesRQ> getAttributesInRange(int limit) {
        List<Pair<String, String>> content = ContentUtils.readAttributes("demo/content/attributes.txt");
        int fromIndex = random.nextInt(content.size() - limit);
        return content.subList(fromIndex, fromIndex + limit).stream().map(it -> {
            if (((String)it.getKey()).isEmpty()) {
                return new ItemAttributesRQ(null, (String)it.getValue());
            }
            return new ItemAttributesRQ((String)it.getKey(), (String)it.getValue());
        }).collect(Collectors.toSet());
    }

    static String getSuiteDescription() {
        List<String> content = ContentUtils.readToList("demo/content/suite-description.txt");
        return content.get(random.nextInt(content.size()));
    }

    static String getStepDescription() {
        List<String> content = ContentUtils.readToList("demo/content/step-description.txt");
        return content.get(random.nextInt(content.size()));
    }

    static String getTestDescription() {
        List<String> content = ContentUtils.readToList("demo/content/test-description.txt");
        return content.get(random.nextInt(content.size()));
    }

    static String getLaunchDescription() {
        return ContentUtils.readToString("demo/content/description.txt");
    }

    static List<String> getErrorLogs() {
        return IntStream.range(0, 2).mapToObj(i -> {
            int errorNumber = random.nextInt(1, 9);
            return ContentUtils.readToString("demo/errors/" + errorNumber + ".txt");
        }).collect(Collectors.toList());
    }

    static String getLogMessage() {
        List<String> logs = ContentUtils.readToList("demo/content/demo_logs.txt");
        return logs.get(random.nextInt(logs.size()));
    }

    static boolean getWithProbability(int probability) {
        Preconditions.checkArgument((boolean)PROBABILITY_RANGE.contains((Comparable)Integer.valueOf(probability)), (String)"%s is not in range [%s]", (int)probability, PROBABILITY_RANGE);
        return Range.closedOpen((Comparable)((Integer)PROBABILITY_RANGE.lowerEndpoint()), (Comparable)Integer.valueOf(probability)).contains((Comparable)Integer.valueOf(random.nextInt((Integer)PROBABILITY_RANGE.upperEndpoint())));
    }

    static Issue getProductBug() {
        Issue issue = new Issue();
        issue.setIssueType(TestItemIssueGroup.PRODUCT_BUG.getLocator());
        issue.setComment(ContentUtils.bugDescription("demo/content/comments/product.txt"));
        return issue;
    }

    static Issue getAutomationBug() {
        Issue issue = new Issue();
        issue.setIssueType(TestItemIssueGroup.AUTOMATION_BUG.getLocator());
        issue.setComment(ContentUtils.bugDescription("demo/content/comments/automation.txt"));
        return issue;
    }

    static Issue getSystemIssue() {
        Issue issue = new Issue();
        issue.setIssueType(TestItemIssueGroup.SYSTEM_ISSUE.getLocator());
        issue.setComment(ContentUtils.bugDescription("demo/content/comments/system.txt"));
        return issue;
    }

    static Issue getInvestigate() {
        Issue issue = new Issue();
        issue.setIssueType(TestItemIssueGroup.TO_INVESTIGATE.getLocator());
        issue.setComment(ContentUtils.bugDescription("demo/content/comments/investigate.txt"));
        return issue;
    }

    private static String bugDescription(String resource) {
        String description = null;
        if (random.nextBoolean()) {
            List<String> descriptions = ContentUtils.readToList(resource);
            description = descriptions.get(random.nextInt(descriptions.size()));
        }
        return description;
    }

    private static List<String> readToList(String resource) {
        List<String> content;
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(new ClassPathResource(resource).getInputStream(), StandardCharsets.UTF_8));){
            content = reader.lines().collect(Collectors.toList());
        }
        catch (IOException e) {
            throw new ReportPortalException("Missing demo content.", (Throwable)e);
        }
        return content;
    }

    private static List<Pair<String, String>> readAttributes(String resource) {
        List<Pair<String, String>> content;
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(new ClassPathResource(resource).getInputStream(), StandardCharsets.UTF_8));){
            content = reader.lines().map(it -> {
                if (it.contains(":")) {
                    return Pair.of((Object)it.split(":")[0], (Object)it.split(":")[1]);
                }
                return Pair.of((Object)"", (Object)it);
            }).collect(Collectors.toList());
        }
        catch (IOException e) {
            throw new ReportPortalException("Missing demo content.", (Throwable)e);
        }
        return content;
    }

    private static String readToString(String resource) {
        String content;
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(new ClassPathResource(resource).getInputStream(), StandardCharsets.UTF_8));){
            content = reader.lines().collect(Collectors.joining("\n"));
        }
        catch (IOException e) {
            throw new ReportPortalException("Missing demo content.", (Throwable)e);
        }
        return content;
    }

    static String getNameFromType(TestItemTypeEnum type) {
        return CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, type.name());
    }
}

