/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.job;

import com.epam.ta.reportportal.commons.querygen.Queryable;
import com.epam.ta.reportportal.core.configs.SchedulerConfiguration;
import com.epam.ta.reportportal.dao.ProjectRepository;
import com.epam.ta.reportportal.entity.enums.KeepLogsDelay;
import com.epam.ta.reportportal.entity.enums.ProjectAttributeEnum;
import com.epam.ta.reportportal.entity.project.Project;
import com.epam.ta.reportportal.entity.project.ProjectUtils;
import com.epam.ta.reportportal.exception.ReportPortalException;
import com.epam.ta.reportportal.job.JobUtil;
import com.epam.ta.reportportal.job.PageUtil;
import com.epam.ta.reportportal.job.service.LogCleanerService;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.time.Duration;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Profile;
import org.springframework.stereotype.Service;

@Service
@Profile(value={"!unittest"})
public class CleanLogsJob
implements Job {
    private static final Logger LOGGER = LoggerFactory.getLogger(CleanLogsJob.class);
    public static final int DEFAULT_THREAD_COUNT = 5;
    @Value(value="5")
    private Integer threadsCount;
    private final ProjectRepository projectRepository;
    private final LogCleanerService logCleaner;
    private final SchedulerConfiguration.CleanLogsJobProperties cleanLogsJobProperties;

    @Autowired
    public CleanLogsJob(ProjectRepository projectRepository, LogCleanerService logCleaner, SchedulerConfiguration.CleanLogsJobProperties cleanLogsJobProperties) {
        this.projectRepository = projectRepository;
        this.logCleaner = logCleaner;
        this.cleanLogsJobProperties = cleanLogsJobProperties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(JobExecutionContext context) throws JobExecutionException {
        LOGGER.info("Cleaning outdated logs has been started");
        ExecutorService executor = Executors.newFixedThreadPool(Optional.ofNullable(this.threadsCount).orElse(5), new ThreadFactoryBuilder().setNameFormat("clean-logs-job-thread-%d").build());
        PageUtil.iterateOverPages(pageable -> this.projectRepository.findAllIdsAndProjectAttributes((Queryable)JobUtil.buildProjectAttributesFilter(ProjectAttributeEnum.KEEP_LOGS), pageable), projects -> projects.forEach(project -> {
            AtomicLong removedLogsCount = new AtomicLong(0L);
            executor.submit(() -> {
                try {
                    LOGGER.debug("Cleaning outdated logs for project {} has been started", (Object)project.getId());
                    this.proceedLogsRemoving((Project)project, removedLogsCount);
                }
                catch (Exception e) {
                    LOGGER.debug("Cleaning outdated logs for project {} has been failed", (Object)project.getId(), (Object)e);
                }
                LOGGER.debug("Cleaning outdated logs for project {} has been finished. Total logs removed: {}", (Object)project.getId(), (Object)removedLogsCount.get());
            });
        }));
        try {
            executor.shutdown();
            if (!executor.awaitTermination(this.cleanLogsJobProperties.getTimeout().intValue(), TimeUnit.SECONDS)) {
                executor.shutdownNow();
            }
        }
        catch (InterruptedException e) {
            LOGGER.debug("Waiting for tasks execution has been failed", (Throwable)e);
        }
        finally {
            executor.shutdownNow();
        }
    }

    private void proceedLogsRemoving(Project project, AtomicLong removedLogsCount) {
        ProjectUtils.extractAttributeValue((Project)project, (ProjectAttributeEnum)ProjectAttributeEnum.KEEP_LOGS).map(it -> Duration.ofDays(((KeepLogsDelay)KeepLogsDelay.findByName((String)it).orElseThrow(() -> new ReportPortalException("Incorrect keep logs delay period: " + it))).getDays())).filter(it -> !it.isZero()).ifPresent(it -> this.logCleaner.removeOutdatedLogs(project, (Duration)it, removedLogsCount));
    }
}

