/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.job;

import com.epam.ta.reportportal.commons.validation.Suppliers;
import com.epam.ta.reportportal.core.configs.Conditions;
import com.epam.ta.reportportal.core.plugin.Pf4jPluginBox;
import com.epam.ta.reportportal.core.plugin.Plugin;
import com.epam.ta.reportportal.dao.IntegrationTypeRepository;
import com.epam.ta.reportportal.entity.integration.IntegrationType;
import com.epam.ta.reportportal.job.service.PluginLoaderService;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.validation.constraints.NotNull;
import org.pf4j.PluginWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Conditional;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;

@Conditional(value={Conditions.NotTestCondition.class})
@Service
public class CleanOutdatedPluginsJob {
    private static final Logger LOGGER = LoggerFactory.getLogger(CleanOutdatedPluginsJob.class);
    private final String pluginsTempPath;
    private final IntegrationTypeRepository integrationTypeRepository;
    private final Pf4jPluginBox pluginBox;
    private final PluginLoaderService pluginLoaderService;

    @Autowired
    public CleanOutdatedPluginsJob(@Value(value="${rp.plugins.temp.path}") String pluginsTempPath, IntegrationTypeRepository integrationTypeRepository, Pf4jPluginBox pf4jPluginBox, PluginLoaderService pluginLoaderService) {
        this.pluginsTempPath = pluginsTempPath;
        this.integrationTypeRepository = integrationTypeRepository;
        this.pluginBox = pf4jPluginBox;
        this.pluginLoaderService = pluginLoaderService;
    }

    @Scheduled(fixedDelayString="${com.ta.reportportal.job.clean.outdated.plugins.cron}")
    public void execute() {
        this.removeTemporaryPlugins();
        List integrationTypes = this.integrationTypeRepository.findAll();
        integrationTypes.stream().filter(it -> it.getDetails() == null || it.getDetails().getDetails() == null).forEach(this.pluginLoaderService::checkAndDeleteIntegrationType);
        this.unloadRemovedPlugins(integrationTypes);
        this.unloadDisabledPlugins(integrationTypes);
    }

    private void removeTemporaryPlugins() {
        Path tempPluginsPath = Paths.get(this.pluginsTempPath, new String[0]);
        LOGGER.debug("Searching for temporary plugins...");
        try (Stream<Path> pathStream = Files.walk(tempPluginsPath, new FileVisitOption[0]);){
            pathStream.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).forEach(path -> Optional.ofNullable(path.getFileName()).ifPresent(fileName -> {
                if (!this.pluginBox.isInUploadingState(fileName.toString())) {
                    try {
                        Files.deleteIfExists(path);
                        LOGGER.debug((String)Suppliers.formattedSupplier((String)"Temporary plugin - '{}' has been removed", (Object[])new Object[]{path}).get());
                    }
                    catch (IOException e) {
                        LOGGER.error("Error has occurred during temporary plugin file removing", (Throwable)e);
                    }
                } else {
                    LOGGER.debug((String)Suppliers.formattedSupplier((String)"Uploading of the plugin - '{}' is still in progress.", (Object[])new Object[]{path}).get());
                }
            }));
        }
        catch (IOException e) {
            LOGGER.error("Error has occurred during temporary plugins folder listing", (Throwable)e);
        }
        LOGGER.debug("Temporary plugins removing has finished...");
    }

    private void unloadRemovedPlugins(List<IntegrationType> integrationTypes) {
        LOGGER.debug("Unloading of removed plugins...");
        List<String> pluginIds = this.pluginBox.getPlugins().stream().map(Plugin::getId).collect(Collectors.toList());
        pluginIds.removeAll(integrationTypes.stream().map(IntegrationType::getName).collect(Collectors.toList()));
        pluginIds.forEach(pluginId -> this.pluginBox.getPluginById((String)pluginId).ifPresent(plugin -> {
            if (!this.isPluginStillBeingUploaded((PluginWrapper)plugin) && !this.pluginBox.deletePlugin((PluginWrapper)plugin)) {
                LOGGER.error("Error has occurred during plugin file removing from the plugins directory");
            }
        }));
        LOGGER.debug("Unloading of removed plugins has finished...");
    }

    private boolean isPluginStillBeingUploaded(@NotNull PluginWrapper pluginWrapper) {
        return this.pluginBox.isInUploadingState(pluginWrapper.getPluginPath().getFileName().toString());
    }

    private void unloadDisabledPlugins(List<IntegrationType> integrationTypes) {
        List<IntegrationType> disabledPlugins = integrationTypes.stream().filter(it -> !it.isEnabled()).collect(Collectors.toList());
        disabledPlugins.forEach(dp -> this.pluginBox.getPluginById(dp.getName()).ifPresent(plugin -> {
            if (this.pluginBox.unloadPlugin((IntegrationType)dp)) {
                LOGGER.debug((String)Suppliers.formattedSupplier((String)"Plugin - '{}' has been successfully unloaded.", (Object[])new Object[]{plugin.getPluginId()}).get());
            } else {
                LOGGER.error((String)Suppliers.formattedSupplier((String)"Error during unloading the plugin with id = '{}'.", (Object[])new Object[]{plugin.getPluginId()}).get());
            }
        }));
    }
}

