/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.util;

import com.epam.ta.reportportal.ws.model.SystemInfoRS;
import com.sun.management.OperatingSystemMXBean;
import java.lang.management.ManagementFactory;
import org.springframework.stereotype.Service;

@Service(value="systemInfo")
public class SystemInformatorService {
    private String OS_FORMATTER = "%s ver.%s arch.%s";
    private OperatingSystemMXBean oper = (OperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean();

    public SystemInfoRS getSystemInformation() {
        SystemInfoRS response = new SystemInfoRS();
        response.setOsVersion(this.getFormattedOs());
        response.setCpuUsage(this.getFormattedCPU());
        response.setMemUsage(this.getMemLoad());
        return response;
    }

    private String getFormattedOs() {
        return String.format(this.OS_FORMATTER, this.oper.getName(), this.oper.getVersion(), this.oper.getArch());
    }

    private float getFormattedCPU() {
        return Double.valueOf(this.oper.getSystemCpuLoad() * 100.0).floatValue();
    }

    private float getMemLoad() {
        float leftPerc = (float)this.oper.getFreePhysicalMemorySize() / (float)this.oper.getTotalPhysicalMemorySize() * 100.0f;
        return 100.0f - leftPerc;
    }
}

