/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.ws.controller;

import com.epam.ta.reportportal.commons.EntityUtils;
import com.epam.ta.reportportal.commons.ReportPortalUser;
import com.epam.ta.reportportal.commons.querygen.CompositeFilter;
import com.epam.ta.reportportal.commons.querygen.Filter;
import com.epam.ta.reportportal.commons.querygen.Queryable;
import com.epam.ta.reportportal.core.item.DeleteTestItemHandler;
import com.epam.ta.reportportal.core.item.FinishTestItemHandler;
import com.epam.ta.reportportal.core.item.GetTestItemHandler;
import com.epam.ta.reportportal.core.item.StartTestItemHandler;
import com.epam.ta.reportportal.core.item.UpdateTestItemHandler;
import com.epam.ta.reportportal.core.item.history.TestItemsHistoryHandler;
import com.epam.ta.reportportal.core.item.impl.history.param.HistoryRequestParams;
import com.epam.ta.reportportal.entity.item.TestItem;
import com.epam.ta.reportportal.util.ProjectExtractor;
import com.epam.ta.reportportal.ws.model.BulkInfoUpdateRQ;
import com.epam.ta.reportportal.ws.model.EntryCreatedAsyncRS;
import com.epam.ta.reportportal.ws.model.FinishTestItemRQ;
import com.epam.ta.reportportal.ws.model.OperationCompletionRS;
import com.epam.ta.reportportal.ws.model.StartTestItemRQ;
import com.epam.ta.reportportal.ws.model.TestItemHistoryElement;
import com.epam.ta.reportportal.ws.model.TestItemResource;
import com.epam.ta.reportportal.ws.model.issue.DefineIssueRQ;
import com.epam.ta.reportportal.ws.model.issue.Issue;
import com.epam.ta.reportportal.ws.model.item.ExternalIssueRQ;
import com.epam.ta.reportportal.ws.model.item.LinkExternalIssueRQ;
import com.epam.ta.reportportal.ws.model.item.UnlinkExternalIssueRQ;
import com.epam.ta.reportportal.ws.model.item.UpdateTestItemRQ;
import com.epam.ta.reportportal.ws.resolver.FilterFor;
import com.epam.ta.reportportal.ws.resolver.SortFor;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import org.jooq.Operator;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.http.HttpStatus;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.core.annotation.AuthenticationPrincipal;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/{projectName}/item"})
@PreAuthorize(value="hasPermission(#projectName.toLowerCase(), 'isAssignedToProject')")
public class TestItemController {
    public static final String HISTORY_TYPE_PARAM = "type";
    public static final String FILTER_ID_REQUEST_PARAM = "filterId";
    public static final String IS_LATEST_LAUNCHES_REQUEST_PARAM = "isLatest";
    public static final String LAUNCHES_LIMIT_REQUEST_PARAM = "launchesLimit";
    private static final String HISTORY_DEPTH_PARAM = "historyDepth";
    private static final String HISTORY_DEPTH_DEFAULT_VALUE = "5";
    private static final String LAUNCHES_LIMIT_DEFAULT_VALUE = "0";
    private final StartTestItemHandler startTestItemHandler;
    private final DeleteTestItemHandler deleteTestItemHandler;
    private final FinishTestItemHandler finishTestItemHandler;
    private final UpdateTestItemHandler updateTestItemHandler;
    private final GetTestItemHandler getTestItemHandler;
    private final TestItemsHistoryHandler testItemsHistoryHandler;

    @Autowired
    public TestItemController(StartTestItemHandler startTestItemHandler, DeleteTestItemHandler deleteTestItemHandler, FinishTestItemHandler finishTestItemHandler, UpdateTestItemHandler updateTestItemHandler, GetTestItemHandler getTestItemHandler, TestItemsHistoryHandler testItemsHistoryHandler) {
        this.startTestItemHandler = startTestItemHandler;
        this.deleteTestItemHandler = deleteTestItemHandler;
        this.finishTestItemHandler = finishTestItemHandler;
        this.updateTestItemHandler = updateTestItemHandler;
        this.getTestItemHandler = getTestItemHandler;
        this.testItemsHistoryHandler = testItemsHistoryHandler;
    }

    @PostMapping
    @ResponseStatus(value=HttpStatus.CREATED)
    @ApiOperation(value="Start a root test item")
    @PreAuthorize(value="hasPermission(#projectName.toLowerCase(), 'reporterPermission')")
    public EntryCreatedAsyncRS startRootItem(@PathVariable String projectName, @AuthenticationPrincipal ReportPortalUser user, @RequestBody @Validated StartTestItemRQ startTestItemRQ) {
        return this.startTestItemHandler.startRootItem(user, ProjectExtractor.extractProjectDetails(user, projectName), startTestItemRQ);
    }

    @PostMapping(value={"/{parentItem}"})
    @ResponseStatus(value=HttpStatus.CREATED)
    @ApiOperation(value="Start a child test item")
    @PreAuthorize(value="hasPermission(#projectName.toLowerCase(), 'reporterPermission')")
    public EntryCreatedAsyncRS startChildItem(@PathVariable String projectName, @AuthenticationPrincipal ReportPortalUser user, @PathVariable String parentItem, @RequestBody @Validated StartTestItemRQ startTestItemRQ) {
        return this.startTestItemHandler.startChildItem(user, ProjectExtractor.extractProjectDetails(user, projectName), startTestItemRQ, parentItem);
    }

    @PutMapping(value={"/{testItemId}"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="Finish test item")
    @PreAuthorize(value="hasPermission(#projectName.toLowerCase(), 'reporterPermission')")
    public OperationCompletionRS finishTestItem(@PathVariable String projectName, @AuthenticationPrincipal ReportPortalUser user, @PathVariable String testItemId, @RequestBody @Validated FinishTestItemRQ finishExecutionRQ) {
        return this.finishTestItemHandler.finishTestItem(user, ProjectExtractor.extractProjectDetails(user, projectName), testItemId, finishExecutionRQ);
    }

    @Transactional(readOnly=true)
    @GetMapping(value={"/{itemId}"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="Find test item by ID")
    public TestItemResource getTestItem(@PathVariable String projectName, @AuthenticationPrincipal ReportPortalUser user, @PathVariable String itemId) {
        return this.getTestItemHandler.getTestItem(itemId, ProjectExtractor.extractProjectDetails(user, projectName), user);
    }

    @Transactional(readOnly=true)
    @GetMapping(value={"/uuid/{itemId}"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="Find test item by UUID")
    public TestItemResource getTestItemByUuid(@PathVariable String projectName, @AuthenticationPrincipal ReportPortalUser user, @PathVariable String itemId) {
        return this.getTestItemHandler.getTestItem(itemId, ProjectExtractor.extractProjectDetails(user, projectName), user);
    }

    @Transactional(readOnly=true)
    @GetMapping
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="Find test items by specified filter")
    public Iterable<TestItemResource> getTestItems(@PathVariable String projectName, @AuthenticationPrincipal ReportPortalUser user, @Nullable @RequestParam(value="filter.eq.launchId", required=false) Long launchId, @Nullable @RequestParam(value="filterId", required=false) Long filterId, @RequestParam(value="isLatest", defaultValue="false", required=false) boolean isLatest, @RequestParam(value="launchesLimit", defaultValue="0", required=false) int launchesLimit, @FilterFor(value=TestItem.class) Filter filter, @FilterFor(value=TestItem.class) Queryable predefinedFilter, @SortFor(value=TestItem.class) Pageable pageable) {
        return this.getTestItemHandler.getTestItems((Queryable)new CompositeFilter(Operator.AND, new Queryable[]{filter, predefinedFilter}), pageable, ProjectExtractor.extractProjectDetails(user, projectName), user, launchId, filterId, isLatest, launchesLimit);
    }

    @Transactional
    @DeleteMapping(value={"/{itemId}"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="Delete test item")
    public OperationCompletionRS deleteTestItem(@PathVariable String projectName, @AuthenticationPrincipal ReportPortalUser user, @PathVariable Long itemId) {
        return this.deleteTestItemHandler.deleteTestItem(itemId, ProjectExtractor.extractProjectDetails(user, projectName), user);
    }

    @Transactional
    @DeleteMapping
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="Delete test items by specified ids")
    public List<OperationCompletionRS> deleteTestItems(@PathVariable String projectName, @AuthenticationPrincipal ReportPortalUser user, @RequestParam(value="ids") Set<Long> ids) {
        return this.deleteTestItemHandler.deleteTestItems(ids, ProjectExtractor.extractProjectDetails(user, projectName), user);
    }

    @Transactional
    @PutMapping
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="Update issues of specified test items")
    public List<Issue> defineTestItemIssueType(@PathVariable String projectName, @AuthenticationPrincipal ReportPortalUser user, @RequestBody @Validated DefineIssueRQ request) {
        return this.updateTestItemHandler.defineTestItemsIssues(ProjectExtractor.extractProjectDetails(user, projectName), request, user);
    }

    @Transactional(readOnly=true)
    @GetMapping(value={"/history"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="Load history of test items")
    public Iterable<TestItemHistoryElement> getItemsHistory(@PathVariable String projectName, @AuthenticationPrincipal ReportPortalUser user, @FilterFor(value=TestItem.class) Filter filter, @FilterFor(value=TestItem.class) Queryable predefinedFilter, @SortFor(value=TestItem.class) Pageable pageable, @Nullable @RequestParam(value="filter.eq.parentId", required=false) Long parentId, @Nullable @RequestParam(value="filter.eq.id", required=false) Long itemId, @Nullable @RequestParam(value="filter.eq.launchId", required=false) Long launchId, @Nullable @RequestParam(value="type", required=false) String type, @Nullable @RequestParam(value="filterId", required=false) Long filterId, @RequestParam(value="isLatest", defaultValue="false", required=false) boolean isLatest, @RequestParam(value="launchesLimit", defaultValue="0", required=false) int launchesLimit, @RequestParam(value="historyDepth", required=false, defaultValue="5") int historyDepth) {
        return this.testItemsHistoryHandler.getItemsHistory(ProjectExtractor.extractProjectDetails(user, projectName), (Queryable)new CompositeFilter(Operator.AND, new Queryable[]{filter, predefinedFilter}), pageable, HistoryRequestParams.of(historyDepth, parentId, itemId, launchId, type, filterId, launchesLimit, isLatest), user);
    }

    @Transactional(readOnly=true)
    @GetMapping(value={"/ticket/ids"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="Get tickets that contains a term as a part inside for specified launch")
    public List<String> getTicketIds(@AuthenticationPrincipal ReportPortalUser user, @PathVariable String projectName, @RequestParam(value="launch") Long id, @RequestParam(value="term") String term) {
        return this.getTestItemHandler.getTicketIds(id, EntityUtils.normalizeId((String)term));
    }

    @Transactional(readOnly=true)
    @GetMapping(value={"/attribute/keys"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="Get all unique attribute keys of specified launch")
    public List<String> getAttributeKeys(@PathVariable String projectName, @AuthenticationPrincipal ReportPortalUser user, @RequestParam(value="launch") Long id, @RequestParam(value="filter.cnt.attributeKey") String value) {
        return this.getTestItemHandler.getAttributeKeys(id, value);
    }

    @Transactional(readOnly=true)
    @GetMapping(value={"/attribute/keys/all"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="Get all unique attribute keys of specified launch")
    public List<String> getAttributeKeysForProject(@PathVariable String projectName, @AuthenticationPrincipal ReportPortalUser user, @RequestParam(value="filter.cnt.attributeKey") String value, @RequestParam(value="filterId") Long launchFilterId, @RequestParam(value="isLatest", defaultValue="false", required=false) boolean isLatest, @RequestParam(value="launchesLimit", defaultValue="0") int launchesLimit) {
        return this.getTestItemHandler.getAttributeKeys(launchFilterId, isLatest, launchesLimit, ProjectExtractor.extractProjectDetails(user, projectName), value);
    }

    @Transactional(readOnly=true)
    @GetMapping(value={"/attribute/values"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="Get all unique attribute values of specified launch")
    public List<String> getAttributeValues(@PathVariable String projectName, @AuthenticationPrincipal ReportPortalUser user, @RequestParam(value="launch") Long id, @RequestParam(value="filter.eq.attributeKey", required=false) String key, @RequestParam(value="filter.cnt.attributeValue") String value) {
        return this.getTestItemHandler.getAttributeValues(id, key, value);
    }

    @Transactional
    @PutMapping(value={"/info"})
    @PreAuthorize(value="hasPermission(#projectName.toLowerCase(), 'projectManagerPermission')||hasRole('ADMINISTRATOR')")
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="Bulk update attributes and description")
    public OperationCompletionRS bulkUpdate(@PathVariable String projectName, @RequestBody @Validated BulkInfoUpdateRQ bulkInfoUpdateRQ, @AuthenticationPrincipal ReportPortalUser user) {
        return this.updateTestItemHandler.bulkInfoUpdate(bulkInfoUpdateRQ, ProjectExtractor.extractProjectDetails(user, projectName));
    }

    @Transactional
    @PutMapping(value={"/{itemId}/update"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="Update test item")
    public OperationCompletionRS updateTestItem(@PathVariable String projectName, @AuthenticationPrincipal ReportPortalUser user, @PathVariable Long itemId, @RequestBody @Validated UpdateTestItemRQ rq) {
        return this.updateTestItemHandler.updateTestItem(ProjectExtractor.extractProjectDetails(user, projectName), itemId, rq, user);
    }

    @Transactional
    @PutMapping(value={"/issue/link"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="Attach external issue for specified test items")
    public List<OperationCompletionRS> linkExternalIssues(@PathVariable String projectName, @AuthenticationPrincipal ReportPortalUser user, @RequestBody @Validated LinkExternalIssueRQ rq) {
        return this.updateTestItemHandler.processExternalIssues((ExternalIssueRQ)rq, ProjectExtractor.extractProjectDetails(user, projectName), user);
    }

    @Transactional
    @PutMapping(value={"/issue/unlink"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="Unlink external issue for specified test items")
    public List<OperationCompletionRS> unlinkExternalIssues(@PathVariable String projectName, @AuthenticationPrincipal ReportPortalUser user, @RequestBody @Validated UnlinkExternalIssueRQ rq) {
        return this.updateTestItemHandler.processExternalIssues((ExternalIssueRQ)rq, ProjectExtractor.extractProjectDetails(user, projectName), user);
    }

    @Transactional(readOnly=true)
    @GetMapping(value={"/items"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="Get test items by specified ids")
    public List<TestItemResource> getTestItems(@PathVariable String projectName, @AuthenticationPrincipal ReportPortalUser user, @RequestParam(value="ids") Long[] ids) {
        return this.getTestItemHandler.getTestItems(ids, ProjectExtractor.extractProjectDetails(user, projectName), user);
    }
}

