/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.ws.converter.builders;

import com.epam.ta.reportportal.commons.EntityUtils;
import com.epam.ta.reportportal.entity.enums.LogLevel;
import com.epam.ta.reportportal.entity.item.TestItem;
import com.epam.ta.reportportal.entity.launch.Launch;
import com.epam.ta.reportportal.entity.log.Log;
import com.epam.ta.reportportal.ws.model.log.SaveLogRQ;
import java.time.LocalDateTime;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Supplier;

public class LogBuilder
implements Supplier<Log> {
    private Log log = new Log();

    public LogBuilder addSaveLogRq(SaveLogRQ createLogRQ) {
        this.log.setLogLevel(Integer.valueOf(LogLevel.toCustomLogLevel((String)createLogRQ.getLevel())));
        this.log.setLogMessage(Optional.ofNullable(createLogRQ.getMessage()).orElse("NULL"));
        this.log.setLogTime((LocalDateTime)EntityUtils.TO_LOCAL_DATE_TIME.apply(createLogRQ.getLogTime()));
        this.log.setUuid(Optional.ofNullable(createLogRQ.getUuid()).orElse(UUID.randomUUID().toString()));
        return this;
    }

    public LogBuilder addTestItem(TestItem testItem) {
        this.log.setTestItem(testItem);
        return this;
    }

    public LogBuilder addLaunch(Launch launch) {
        this.log.setLaunch(launch);
        return this;
    }

    @Override
    public Log get() {
        return this.log;
    }
}

